/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.maven.projects;

import javax.inject.Inject;
import org.jboss.forge.facets.Facet;
import org.jboss.forge.facets.FacetFactory;
import org.jboss.forge.facets.Faceted;
import org.jboss.forge.maven.dependencies.MavenDependencyResolver;
import org.jboss.forge.maven.projects.MavenFacet;
import org.jboss.forge.maven.projects.MavenPluginFacet;
import org.jboss.forge.maven.projects.MavenProject;
import org.jboss.forge.maven.projects.facets.MavenDependencyFacet;
import org.jboss.forge.maven.projects.facets.MavenMetadataFacet;
import org.jboss.forge.maven.projects.facets.MavenPackagingFacet;
import org.jboss.forge.maven.projects.facets.MavenResourceFacet;
import org.jboss.forge.projects.Project;
import org.jboss.forge.projects.ProjectLocator;
import org.jboss.forge.projects.facets.DependencyFacet;
import org.jboss.forge.projects.facets.MetadataFacet;
import org.jboss.forge.projects.facets.PackagingFacet;
import org.jboss.forge.projects.facets.ResourceFacet;
import org.jboss.forge.resource.DirectoryResource;
import org.jboss.forge.resource.FileResource;
import org.jboss.forge.resource.Resource;

public class MavenProjectLocator
implements ProjectLocator {
    @Inject
    private MavenDependencyResolver resolver;
    @Inject
    private FacetFactory factory;

    public Project createProject(DirectoryResource dir) {
        MavenProject project = new MavenProject(dir);
        MavenFacet mavenFacet = (MavenFacet)this.factory.create(MavenFacet.class, (Faceted)project);
        MavenPluginFacet mavenPluginFacet = (MavenPluginFacet)this.factory.create(MavenPluginFacet.class, (Faceted)project);
        MetadataFacet metadataFacet = (MetadataFacet)this.factory.create(MavenMetadataFacet.class, (Faceted)project);
        PackagingFacet packagingFacet = (PackagingFacet)this.factory.create(MavenPackagingFacet.class, (Faceted)project);
        DependencyFacet dependencyFacet = (DependencyFacet)this.factory.create(MavenDependencyFacet.class, (Faceted)project);
        ResourceFacet resourceFacet = (ResourceFacet)this.factory.create(MavenResourceFacet.class, (Faceted)project);
        if (!(project.install((Facet)mavenFacet) && project.install((Facet)metadataFacet) && project.install((Facet)packagingFacet) && project.install((Facet)dependencyFacet) && project.install((Facet)resourceFacet) && project.install((Facet)mavenPluginFacet))) {
            throw new IllegalStateException("Could not install Maven into Project located at [" + dir.getFullyQualifiedName() + "]");
        }
        return project;
    }

    public boolean containsProject(DirectoryResource dir) {
        Resource pom = dir.getChild("pom.xml");
        return pom.exists() && pom instanceof FileResource;
    }
}

