/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.maven.projects.facets;

import com.google.common.base.Strings;
import java.io.File;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.jboss.forge.environment.Environment;
import org.jboss.forge.facets.AbstractFacet;
import org.jboss.forge.facets.Faceted;
import org.jboss.forge.maven.projects.MavenFacet;
import org.jboss.forge.maven.projects.MavenFacetImpl;
import org.jboss.forge.maven.projects.MavenProjectBuilder;
import org.jboss.forge.projects.Project;
import org.jboss.forge.projects.building.ProjectBuilder;
import org.jboss.forge.projects.events.PackagingChanged;
import org.jboss.forge.projects.facets.PackagingFacet;
import org.jboss.forge.resource.Resource;
import org.jboss.forge.resource.ResourceFactory;

@Dependent
public class MavenPackagingFacet
extends AbstractFacet<Project>
implements PackagingFacet {
    @Inject
    private Event<PackagingChanged> event;
    @Inject
    private ResourceFactory factory;
    @Inject
    private Environment environment;

    public void setOrigin(Project origin) {
        super.setOrigin((Faceted)origin);
    }

    public void setPackagingType(String type) {
        String oldType = this.getPackagingType();
        if (!oldType.equals(type)) {
            MavenFacet mavenFacet = (MavenFacet)((Project)this.getOrigin()).getFacet(MavenFacet.class);
            Model pom = mavenFacet.getPOM();
            pom.setPackaging(type);
            mavenFacet.setPOM(pom);
            this.event.fire((Object)new PackagingChanged((Project)this.getOrigin(), oldType, type));
        }
    }

    public String getPackagingType() {
        MavenFacet mavenFacet = (MavenFacet)((Project)this.getOrigin()).getFacet(MavenFacet.class);
        Model pom = mavenFacet.getPOM();
        return pom.getPackaging();
    }

    public boolean isInstalled() {
        return ((Project)this.getOrigin()).hasFacet(MavenFacet.class);
    }

    public boolean install() {
        if (this.getPackagingType() == null || this.getPackagingType().isEmpty()) {
            this.setPackagingType("pom");
        }
        return true;
    }

    public Resource<?> getFinalArtifact() {
        MavenFacetImpl mvn = (MavenFacetImpl)((Project)this.getOrigin()).getFacet(MavenFacet.class);
        String directory = mvn.getPartialProjectBuildingResult().getProject().getBuild().getDirectory();
        String finalName = mvn.getPartialProjectBuildingResult().getProject().getBuild().getFinalName();
        if (Strings.isNullOrEmpty((String)directory)) {
            throw new IllegalStateException("Project build directory is not configured");
        }
        if (Strings.isNullOrEmpty((String)finalName)) {
            throw new IllegalStateException("Project final artifact name is not configured");
        }
        return this.factory.create((Object)new File(directory.trim() + "/" + finalName + "." + this.getPackagingType().toLowerCase()));
    }

    public Resource<?> executeBuild(String ... args) {
        return this.createBuilder().addArguments(args).build();
    }

    public ProjectBuilder createBuilder() {
        return new MavenProjectBuilder(this.environment, (Project)this.getOrigin());
    }

    public String getFinalName() {
        MavenFacet mavenFacet = (MavenFacet)((Project)this.getOrigin()).getFacet(MavenFacet.class);
        Model pom = mavenFacet.getPOM();
        return pom.getBuild().getFinalName();
    }

    public void setFinalName(String finalName) {
        MavenFacet mavenFacet = (MavenFacet)((Project)this.getOrigin()).getFacet(MavenFacet.class);
        Model pom = mavenFacet.getPOM();
        Build build = pom.getBuild();
        if (build == null) {
            build = new Build();
            pom.setBuild(build);
        }
        pom.getBuild().setFinalName(finalName);
        mavenFacet.setPOM(pom);
    }
}

