/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.maven.projects;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.Dependent;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Repository;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.jboss.forge.dependencies.Coordinate;
import org.jboss.forge.dependencies.DependencyRepository;
import org.jboss.forge.dependencies.builder.CoordinateBuilder;
import org.jboss.forge.dependencies.util.Dependencies;
import org.jboss.forge.facets.AbstractFacet;
import org.jboss.forge.maven.plugins.Execution;
import org.jboss.forge.maven.plugins.MavenPlugin;
import org.jboss.forge.maven.plugins.MavenPluginAdapter;
import org.jboss.forge.maven.plugins.MavenPluginBuilder;
import org.jboss.forge.maven.projects.MavenFacet;
import org.jboss.forge.maven.projects.MavenPluginFacet;
import org.jboss.forge.maven.projects.facets.exceptions.PluginNotFoundException;
import org.jboss.forge.parser.java.util.Strings;
import org.jboss.forge.projects.Project;

@Dependent
public class MavenPluginFacetImpl
extends AbstractFacet<Project>
implements MavenPluginFacet {
    private static final String DEFAULT_GROUPID = "org.apache.maven.plugins";

    public boolean install() {
        return true;
    }

    public boolean isInstalled() {
        return ((Project)this.getOrigin()).hasFacet(MavenFacet.class);
    }

    private List<Plugin> getPluginsPOM(boolean managedPlugin, boolean effectivePlugin) {
        MavenFacet mavenCoreFacet = (MavenFacet)((Project)this.getOrigin()).getFacet(MavenFacet.class);
        Build build = mavenCoreFacet.getPOM().getBuild();
        if (build != null) {
            if (managedPlugin) {
                PluginManagement pluginManagement = build.getPluginManagement();
                if (pluginManagement != null) {
                    return pluginManagement.getPlugins();
                }
            } else {
                return build.getPlugins();
            }
        }
        return Collections.emptyList();
    }

    private List<MavenPlugin> listConfiguredPlugins(boolean managedPlugin, boolean effectivePlugin) {
        ArrayList<MavenPlugin> plugins = new ArrayList<MavenPlugin>();
        List<Plugin> pomPlugins = this.getPluginsPOM(managedPlugin, effectivePlugin);
        for (Plugin plugin : pomPlugins) {
            MavenPluginAdapter adapter = new MavenPluginAdapter(plugin);
            MavenPluginBuilder pluginBuilder = MavenPluginBuilder.create().setCoordinate((Coordinate)CoordinateBuilder.create().setGroupId(plugin.getGroupId()).setArtifactId(plugin.getArtifactId()).setVersion(plugin.getVersion())).setConfiguration(adapter.getConfig());
            for (Execution execution : adapter.listExecutions()) {
                pluginBuilder.addExecution(execution);
            }
            plugins.add((MavenPlugin)pluginBuilder);
        }
        return plugins;
    }

    private void addPlugin(MavenPlugin plugin, boolean managedPlugin) {
        MavenFacet mavenCoreFacet = (MavenFacet)((Project)this.getOrigin()).getFacet(MavenFacet.class);
        Model pom = mavenCoreFacet.getPOM();
        Build build = pom.getBuild();
        if (build == null) {
            build = new Build();
        }
        if (managedPlugin) {
            PluginManagement pluginManagement = build.getPluginManagement();
            if (pluginManagement == null) {
                pluginManagement = new PluginManagement();
                build.setPluginManagement(pluginManagement);
            }
            pluginManagement.addPlugin((Plugin)new MavenPluginAdapter(plugin));
        } else {
            build.addPlugin((Plugin)new MavenPluginAdapter(plugin));
        }
        pom.setBuild(build);
        mavenCoreFacet.setPOM(pom);
    }

    private MavenPlugin getPlugin(Coordinate dependency, boolean managedPlugin, boolean effectivePlugin) {
        String groupId = dependency.getGroupId();
        groupId = groupId == null || groupId.equals("") ? DEFAULT_GROUPID : groupId;
        for (MavenPlugin mavenPlugin : this.listConfiguredPlugins(managedPlugin, effectivePlugin)) {
            Coordinate temp = mavenPlugin.getCoordinate();
            if (!Dependencies.areEquivalent((Coordinate)temp, (Coordinate)CoordinateBuilder.create((Coordinate)dependency).setGroupId(groupId))) continue;
            return mavenPlugin;
        }
        throw new PluginNotFoundException(groupId, dependency.getArtifactId());
    }

    public boolean hasPlugin(Coordinate dependency, boolean managedPlugin, boolean effectivePlugin) {
        try {
            this.getPlugin(dependency, managedPlugin, effectivePlugin);
            return true;
        }
        catch (PluginNotFoundException ex) {
            return false;
        }
    }

    private void removePlugin(Coordinate dependency, boolean managedPlugin) {
        MavenPlugin pluginToRemove = null;
        if (managedPlugin && this.hasManagedPlugin(dependency)) {
            pluginToRemove = this.getManagedPlugin(dependency);
        } else if (this.hasPlugin(dependency)) {
            pluginToRemove = this.getPlugin(dependency);
        }
        if (pluginToRemove != null) {
            MavenFacet mavenCoreFacet = (MavenFacet)((Project)this.getOrigin()).getFacet(MavenFacet.class);
            Model pom = mavenCoreFacet.getPOM();
            Build build = pom.getBuild();
            if (managedPlugin) {
                PluginManagement pluginManagement = build.getPluginManagement();
                pluginManagement.removePlugin((Plugin)new MavenPluginAdapter(pluginToRemove));
            } else {
                build.removePlugin((Plugin)new MavenPluginAdapter(pluginToRemove));
            }
            pom.setBuild(build);
            mavenCoreFacet.setPOM(pom);
        }
    }

    private void updatePlugin(MavenPlugin plugin, boolean managedPlugin) {
        this.removePlugin(plugin.getCoordinate(), managedPlugin);
        if (!this.hasPlugin(plugin.getCoordinate(), managedPlugin, false)) {
            this.addPlugin(plugin, managedPlugin);
        }
    }

    public List<MavenPlugin> listConfiguredPlugins() {
        return this.listConfiguredPlugins(false, false);
    }

    public List<MavenPlugin> listConfiguredEffectivePlugins() {
        return this.listConfiguredPlugins(false, true);
    }

    public List<MavenPlugin> listConfiguredManagedPlugins() {
        return this.listConfiguredPlugins(true, false);
    }

    public List<MavenPlugin> listConfiguredEffectiveManagedPlugins() {
        return this.listConfiguredPlugins(true, true);
    }

    public void addPlugin(MavenPlugin plugin) {
        this.addPlugin(plugin, false);
    }

    public void addManagedPlugin(MavenPlugin plugin) {
        this.addPlugin(plugin, true);
    }

    public MavenPlugin getPlugin(Coordinate coordinate) {
        return this.getPlugin(coordinate, false, false);
    }

    public MavenPlugin getEffectivePlugin(Coordinate dependency) {
        return this.getPlugin(dependency, false, true);
    }

    public MavenPlugin getManagedPlugin(Coordinate dependency) {
        return this.getPlugin(dependency, true, false);
    }

    public MavenPlugin getEffectiveManagedPlugin(Coordinate dependency) {
        return this.getPlugin(dependency, true, true);
    }

    public boolean hasPlugin(Coordinate dependency) {
        return this.hasPlugin(dependency, false, false);
    }

    public boolean hasEffectivePlugin(Coordinate dependency) {
        return this.hasPlugin(dependency, false, true);
    }

    public boolean hasManagedPlugin(Coordinate dependency) {
        return this.hasPlugin(dependency, true, false);
    }

    public boolean hasEffectiveManagedPlugin(Coordinate managedDependency) {
        return this.hasPlugin(managedDependency, true, true);
    }

    public void removePlugin(Coordinate dependency) {
        this.removePlugin(dependency, false);
    }

    public void removeManagedPlugin(Coordinate dependency) {
        this.removePlugin(dependency, true);
    }

    public void updatePlugin(MavenPlugin plugin) {
        this.updatePlugin(plugin, false);
    }

    public void updateManagedPlugin(MavenPlugin plugin) {
        this.updatePlugin(plugin, true);
    }

    public void addPluginRepository(String name, String url) {
        if (!this.hasPluginRepository(url)) {
            MavenFacet maven = (MavenFacet)((Project)this.getOrigin()).getFacet(MavenFacet.class);
            Model pom = maven.getPOM();
            Repository repo = new Repository();
            repo.setId(name);
            repo.setUrl(url);
            pom.getPluginRepositories().add(repo);
            maven.setPOM(pom);
        }
    }

    public boolean hasPluginRepository(String url) {
        MavenFacet maven;
        Model pom;
        List repositories;
        if (url != null && (repositories = (pom = (maven = (MavenFacet)((Project)this.getOrigin()).getFacet(MavenFacet.class)).getPOM()).getPluginRepositories()) != null) {
            for (Repository repo : repositories) {
                if (!repo.getUrl().trim().equals(url.trim())) continue;
                repositories.remove(repo);
                maven.setPOM(pom);
                return true;
            }
        }
        return false;
    }

    public DependencyRepository removePluginRepository(String url) {
        if (url != null) {
            MavenFacet maven = (MavenFacet)((Project)this.getOrigin()).getFacet(MavenFacet.class);
            Model pom = maven.getPOM();
            List repos = pom.getPluginRepositories();
            for (Repository repo : repos) {
                if (!repo.getUrl().equals(url.trim())) continue;
                repos.remove(repo);
                maven.setPOM(pom);
                return new DependencyRepository(repo.getId(), repo.getUrl());
            }
        }
        return null;
    }

    public List<DependencyRepository> getPluginRepositories() {
        ArrayList<DependencyRepository> results = new ArrayList<DependencyRepository>();
        MavenFacet maven = (MavenFacet)((Project)this.getOrigin()).getFacet(MavenFacet.class);
        Model pom = maven.getPOM();
        List repos = pom.getPluginRepositories();
        if (repos != null) {
            for (Repository repo : repos) {
                results.add(new DependencyRepository(repo.getId(), repo.getUrl()));
            }
        }
        return Collections.unmodifiableList(results);
    }

    public MavenPlugin merge(MavenPlugin dominant, MavenPlugin recessive) {
        MavenPluginAdapter merged = new MavenPluginAdapter(dominant);
        if (Dependencies.areEquivalent((Coordinate)dominant.getCoordinate(), (Coordinate)recessive.getCoordinate())) {
            MavenPluginAdapter recessiveAdaptater = new MavenPluginAdapter(recessive);
            Xpp3Dom mergedDomConfig = Xpp3Dom.mergeXpp3Dom((Xpp3Dom)((Xpp3Dom)merged.getConfiguration()), (Xpp3Dom)((Xpp3Dom)recessiveAdaptater.getConfiguration()));
            merged.setConfiguration((Object)mergedDomConfig);
            List<PluginExecution> mergedExecutions = this.mergePluginsExecutions(merged.getExecutionsAsMap(), recessiveAdaptater.getExecutionsAsMap());
            merged.setExecutions(mergedExecutions);
            if (Strings.isNullOrEmpty((String)merged.getVersion())) {
                merged.setVersion(recessiveAdaptater.getVersion());
            }
            if (Strings.isNullOrEmpty((String)merged.getExtensions())) {
                merged.setExtensions(recessiveAdaptater.getExtensions());
            }
            if (Strings.isNullOrEmpty((String)merged.getInherited())) {
                merged.setExtensions(recessiveAdaptater.getInherited());
            }
        }
        return merged;
    }

    private List<PluginExecution> mergePluginsExecutions(Map<String, PluginExecution> dominant, Map<String, PluginExecution> recessive) {
        PluginExecution mergedPluginExecution;
        PluginExecution pluginExecution;
        ArrayList<PluginExecution> executions = new ArrayList<PluginExecution>();
        for (Map.Entry<String, PluginExecution> entry : dominant.entrySet()) {
            pluginExecution = entry.getValue();
            mergedPluginExecution = new PluginExecution();
            mergedPluginExecution.setId(pluginExecution.getId());
            if (Strings.isNullOrEmpty((String)pluginExecution.getPhase()) && recessive.containsKey(entry.getKey())) {
                mergedPluginExecution.setPhase(recessive.get(entry.getKey()).getPhase());
            } else {
                mergedPluginExecution.setPhase(pluginExecution.getPhase());
            }
            HashMap<String, Boolean> hasGoals = new HashMap<String, Boolean>();
            for (String goal : pluginExecution.getGoals()) {
                mergedPluginExecution.addGoal(goal);
                hasGoals.put(goal, new Boolean(true));
            }
            if (recessive.containsKey(entry.getKey())) {
                for (String goal : recessive.get(entry.getKey()).getGoals()) {
                    if (hasGoals.containsKey(goal)) continue;
                    mergedPluginExecution.addGoal(goal);
                }
            }
            if (pluginExecution.getConfiguration() != null) {
                if (recessive.containsKey(entry.getKey()) && recessive.get(entry.getKey()).getConfiguration() != null) {
                    Xpp3Dom mergedDomConfig = Xpp3Dom.mergeXpp3Dom((Xpp3Dom)((Xpp3Dom)pluginExecution.getConfiguration()), (Xpp3Dom)((Xpp3Dom)recessive.get(entry.getKey()).getConfiguration()));
                    mergedPluginExecution.setConfiguration((Object)mergedDomConfig);
                } else {
                    mergedPluginExecution.setConfiguration(pluginExecution.getConfiguration());
                }
            }
            executions.add(mergedPluginExecution);
        }
        for (Map.Entry<String, PluginExecution> entry : recessive.entrySet()) {
            if (dominant.containsKey(entry.getKey())) continue;
            pluginExecution = entry.getValue();
            mergedPluginExecution = new PluginExecution();
            mergedPluginExecution.setId(pluginExecution.getId());
            mergedPluginExecution.setPhase(pluginExecution.getPhase());
            for (String goal : pluginExecution.getGoals()) {
                mergedPluginExecution.addGoal(goal);
            }
            if (pluginExecution.getConfiguration() != null) {
                mergedPluginExecution.setConfiguration(pluginExecution.getConfiguration());
            }
            executions.add(mergedPluginExecution);
        }
        return executions;
    }
}

