/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.maven.projects.facets;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.Dependent;
import org.jboss.forge.dependencies.Coordinate;
import org.jboss.forge.dependencies.builder.CoordinateBuilder;
import org.jboss.forge.facets.AbstractFacet;
import org.jboss.forge.maven.plugins.ConfigurationElement;
import org.jboss.forge.maven.plugins.ConfigurationElementBuilder;
import org.jboss.forge.maven.plugins.MavenPlugin;
import org.jboss.forge.maven.plugins.MavenPluginBuilder;
import org.jboss.forge.maven.projects.MavenFacet;
import org.jboss.forge.maven.projects.MavenPluginFacet;
import org.jboss.forge.projects.Project;
import org.jboss.forge.projects.facets.PackagingFacet;
import org.jboss.forge.projects.facets.WebResourceFacet;
import org.jboss.forge.resource.DirectoryResource;
import org.jboss.forge.resource.FileResource;

@Dependent
public class MavenWebResourceFacet
extends AbstractFacet<Project>
implements WebResourceFacet {
    public DirectoryResource getWebRootDirectory() {
        return ((Project)this.getOrigin()).getProjectRoot().getChildDirectory("src" + File.separator + "main" + File.separator + "webapp");
    }

    public List<DirectoryResource> getWebRootDirectories() {
        ArrayList<DirectoryResource> result = new ArrayList<DirectoryResource>();
        result.add(this.getWebRootDirectory());
        return result;
    }

    public boolean isInstalled() {
        Project project = (Project)this.getOrigin();
        MavenFacet mavenFacet = (MavenFacet)project.getFacet(MavenFacet.class);
        String packagingType = ((PackagingFacet)project.getFacet(PackagingFacet.class)).getPackagingType();
        return mavenFacet.isInstalled() && packagingType.equals("war");
    }

    public boolean install() {
        if (!this.isInstalled()) {
            MavenPluginBuilder plugin;
            CoordinateBuilder mvnWarPluginDep;
            for (DirectoryResource folder : this.getWebRootDirectories()) {
                folder.mkdirs();
            }
            MavenPluginFacet plugins = (MavenPluginFacet)((Project)this.getOrigin()).getFacet(MavenPluginFacet.class);
            if (!plugins.hasPlugin((Coordinate)(mvnWarPluginDep = CoordinateBuilder.create().setGroupId("org.apache.maven.plugins").setArtifactId("maven-war-plugin").setVersion("2.3")))) {
                plugin = MavenPluginBuilder.create().setCoordinate((Coordinate)mvnWarPluginDep);
                plugins.addPlugin((MavenPlugin)plugin);
            } else {
                plugin = plugins.getPlugin((Coordinate)mvnWarPluginDep);
            }
            if (plugin.getConfig() == null) {
                // empty if block
            }
            if (!plugin.getConfig().hasConfigurationElement("failOnMissingWebXml")) {
                plugin.getConfig().addConfigurationElement((ConfigurationElement)ConfigurationElementBuilder.create().setName("failOnMissingWebXml").setText("false"));
            } else {
                ConfigurationElementBuilder configElement = ConfigurationElementBuilder.createFromExisting((ConfigurationElement)plugin.getConfig().getConfigurationElement("failOnMissingWebXml"));
                plugin.getConfig().removeConfigurationElement("failOnMissingWebXml");
                plugin.getConfig().addConfigurationElement((ConfigurationElement)configElement);
            }
            plugins.removePlugin((Coordinate)mvnWarPluginDep);
            plugins.addPlugin((MavenPlugin)plugin);
        }
        return true;
    }

    public FileResource<?> getWebResource(String relativePath) {
        return (FileResource)this.getWebRootDirectory().getChild(relativePath);
    }

    public FileResource<?> createWebResource(char[] data, String relativePath) {
        FileResource file = (FileResource)this.getWebRootDirectory().getChild(relativePath);
        file.setContents(data);
        return file;
    }

    public FileResource<?> createWebResource(String data, String relativePath) {
        return this.createWebResource(data.toCharArray(), relativePath);
    }
}

