/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.ui.example.wizards;

import java.util.Arrays;
import javax.inject.Inject;
import org.jboss.forge.convert.Converter;
import org.jboss.forge.ui.context.UIBuilder;
import org.jboss.forge.ui.context.UIContext;
import org.jboss.forge.ui.context.UISelection;
import org.jboss.forge.ui.context.UIValidationContext;
import org.jboss.forge.ui.example.wizards.Bean;
import org.jboss.forge.ui.facets.HintsFacet;
import org.jboss.forge.ui.hints.InputType;
import org.jboss.forge.ui.hints.InputTypes;
import org.jboss.forge.ui.input.UISelectOne;
import org.jboss.forge.ui.metadata.UICommandMetadata;
import org.jboss.forge.ui.result.NavigationResult;
import org.jboss.forge.ui.result.Result;
import org.jboss.forge.ui.result.Results;
import org.jboss.forge.ui.util.Metadata;
import org.jboss.forge.ui.wizard.UIWizardStep;

public class ExampleSelectComponents
implements UIWizardStep {
    @Inject
    private UISelectOne<Bean> radioBean;
    @Inject
    private UISelectOne<Bean> radioBeanTwo;

    public UICommandMetadata getMetadata() {
        return Metadata.forCommand(this.getClass()).name("Step 2").description("Select a folder");
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        ((HintsFacet)this.radioBean.getFacet(HintsFacet.class)).setInputType((InputType)InputTypes.SELECT_ONE_RADIO);
        ((HintsFacet)this.radioBeanTwo.getFacet(HintsFacet.class)).setInputType((InputType)InputTypes.SELECT_ONE_RADIO);
        this.radioBean.setValueChoices(Arrays.asList(new Bean("One"), new Bean("Two"), new Bean("Three")));
        this.radioBeanTwo.setValueChoices(Arrays.asList(new Bean("A"), new Bean("B"), new Bean("C")));
        Converter<Bean, String> converter = new Converter<Bean, String>(){

            public String convert(Bean source) {
                return source.getName();
            }
        };
        this.radioBean.setItemLabelConverter((Converter)converter);
        this.radioBeanTwo.setItemLabelConverter((Converter)converter);
        builder.add(this.radioBean).add(this.radioBeanTwo);
    }

    public void validate(UIValidationContext context) {
    }

    public Result execute(UIContext context) throws Exception {
        return Results.success();
    }

    public boolean isEnabled(UIContext context) {
        UISelection selection = context.getInitialSelection();
        return selection != null;
    }

    public NavigationResult next(UIContext context) throws Exception {
        return null;
    }
}

