/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.ui.example.wizards;

import javax.inject.Inject;
import org.jboss.forge.ui.context.UIBuilder;
import org.jboss.forge.ui.context.UIContext;
import org.jboss.forge.ui.context.UISelection;
import org.jboss.forge.ui.context.UIValidationContext;
import org.jboss.forge.ui.example.wizards.ExampleStepTwo;
import org.jboss.forge.ui.facets.HintsFacet;
import org.jboss.forge.ui.hints.InputType;
import org.jboss.forge.ui.hints.InputTypes;
import org.jboss.forge.ui.input.UIInput;
import org.jboss.forge.ui.metadata.UICommandMetadata;
import org.jboss.forge.ui.result.NavigationResult;
import org.jboss.forge.ui.result.Result;
import org.jboss.forge.ui.result.Results;
import org.jboss.forge.ui.util.Metadata;
import org.jboss.forge.ui.wizard.UIWizardStep;

public class ExampleStepOne
implements UIWizardStep {
    @Inject
    private UIInput<String> address;
    @Inject
    private UIInput<String> password;

    public UICommandMetadata getMetadata() {
        return Metadata.forCommand(this.getClass()).name("Step 1").description("Enter your Address");
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        ((UIInput)this.address.setLabel("Address:")).setRequired(true);
        ((HintsFacet)this.password.getFacet(HintsFacet.class)).setInputType((InputType)InputTypes.SECRET);
        builder.add(this.address).add(this.password);
    }

    public void validate(UIValidationContext context) {
        String value = (String)this.address.getValue();
        if (value != null && !value.isEmpty() && !value.matches("[a-zA-Z0-9, ]+")) {
            context.addValidationError(this.address, "Address contains invalid characters");
        }
    }

    public Result execute(UIContext context) throws Exception {
        return Results.success();
    }

    public boolean isEnabled(UIContext context) {
        UISelection selection = context.getInitialSelection();
        return selection != null;
    }

    public NavigationResult next(UIContext context) throws Exception {
        return Results.navigateTo(ExampleStepTwo.class);
    }
}

