/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.ui.example.wizards;

import javax.inject.Inject;
import org.jboss.forge.ui.context.UIBuilder;
import org.jboss.forge.ui.context.UIContext;
import org.jboss.forge.ui.context.UISelection;
import org.jboss.forge.ui.context.UIValidationContext;
import org.jboss.forge.ui.example.wizards.ExampleSelectComponents;
import org.jboss.forge.ui.example.wizards.ExampleStepOne;
import org.jboss.forge.ui.example.wizards.ExampleStepTwo;
import org.jboss.forge.ui.input.UIInput;
import org.jboss.forge.ui.metadata.UICommandMetadata;
import org.jboss.forge.ui.result.NavigationResult;
import org.jboss.forge.ui.result.Result;
import org.jboss.forge.ui.result.Results;
import org.jboss.forge.ui.util.Metadata;
import org.jboss.forge.ui.wizard.UIWizard;

public class ExampleWizard
implements UIWizard {
    @Inject
    private UIInput<String> firstName;
    @Inject
    private UIInput<Boolean> showSelectComponents;
    @Inject
    private UIInput<Boolean> goToLastStep;

    public UICommandMetadata getMetadata() {
        return Metadata.forCommand(this.getClass()).name("Wizard").description("This is the First screen of the Wizard");
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        ((UIInput)this.firstName.setRequired(true)).setRequiredMessage("First Name must be informed !");
        builder.add(this.firstName).add(this.showSelectComponents).add(this.goToLastStep);
    }

    public void validate(UIValidationContext context) {
        String value = (String)this.firstName.getValue();
        if (value != null && !value.isEmpty() && !value.matches("[a-zA-Z]+")) {
            context.addValidationError(this.firstName, "First Name contains invalid characters");
        }
    }

    public Result execute(UIContext context) throws Exception {
        return Results.success();
    }

    public boolean isEnabled(UIContext context) {
        UISelection selection = context.getInitialSelection();
        return selection != null;
    }

    public NavigationResult next(UIContext context) throws Exception {
        if (this.showSelectComponents.getValue() != null && ((Boolean)this.showSelectComponents.getValue()).booleanValue()) {
            return Results.navigateTo(ExampleSelectComponents.class);
        }
        if (this.goToLastStep.getValue() != null && ((Boolean)this.goToLastStep.getValue()).booleanValue()) {
            return Results.navigateTo(ExampleStepTwo.class);
        }
        return Results.navigateTo(ExampleStepOne.class);
    }
}

