/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.fresh.shell.commands;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Properties;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.apache.log4j.Logger;
import org.jboss.fresh.ctx.Context;
import org.jboss.fresh.deployer.ScriptingCentral;
import org.jboss.fresh.io.BufferInputStream;
import org.jboss.fresh.io.BufferOutputStream;
import org.jboss.fresh.io.BufferReader;
import org.jboss.fresh.io.BufferWriter;
import org.jboss.fresh.io.IOUtils;
import org.jboss.fresh.io.InBuffer;
import org.jboss.fresh.io.OutBuffer;
import org.jboss.fresh.shell.AbstractExecutable;
import org.jboss.fresh.vfs.FileName;
import org.jboss.fresh.vfs.VFS;
import org.jboss.fresh.vfs.impl.SecureVFS;
import org.jboss.fresh.vfs.impl.VFSInputStream;

public class ScriptExe
extends AbstractExecutable {
    private static transient Logger log = Logger.getLogger(ScriptExe.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void process(String execName, String[] params) throws Exception {
        int i;
        log.debug((Object)"entered");
        String langName = null;
        String fname = "unknown";
        PrintWriter out = null;
        BufferedReader in = null;
        BufferInputStream inStream = null;
        BufferOutputStream outStream = null;
        Context context = null;
        Properties props = null;
        boolean isFile = false;
        if (this.helpRequested()) {
            this.printHelp();
            return;
        }
        PrintWriter err = new PrintWriter((Writer)new BufferWriter(this.getStdOut()), true);
        ScriptingCentral sc = (ScriptingCentral)this.getShell().getContext().get((Object)"ScriptingServices");
        if (sc == null) {
            if (this.canThrowEx()) {
                throw new RuntimeException("ScriptingServices not bound in context.");
            }
            err.println("ScriptingServices not bound in context.");
            return;
        }
        String file = null;
        String vfile = null;
        BufferedReader reader = null;
        String enc = this.shell.getEnvProperty("ENCODING");
        String[] args = null;
        if (params.length > 0) {
            i = 0;
            String temp = params[i];
            if ("-f".equals(temp) || "--file".equals(temp)) {
                if (i >= params.length - 1) {
                    this.error("File name missing after parameter: " + temp);
                    return;
                }
                file = params[++i];
            } else if ("-v".equals(params[0]) || "--vfile".equals(params[0])) {
                if (i >= params.length - 1) {
                    this.error("File name missing after parameter: " + temp);
                    return;
                }
                vfile = params[++i];
            }
        }
        if (file != null || vfile != null) {
            args = new String[params.length - 2];
            for (i = 2; i < params.length; ++i) {
                args[i - 2] = params[i];
            }
            fname = file != null ? file : vfile;
            String ext = IOUtils.getExt((String)fname);
            if (ext == null) {
                if (this.canThrowEx()) {
                    throw new RuntimeException("Can't determine scripting language - file has no extension.");
                }
                err.println("Can't determine scripting language - file has no extension.");
                return;
            }
            langName = sc.getLanguageForExtension(ext);
            if (langName == null) {
                if (this.canThrowEx()) {
                    throw new RuntimeException("No scripting language registered for the specified extensions: " + ext);
                }
                err.println("No scripting language registered for the specified extensions: " + ext);
                return;
            }
            FileInputStream ins = null;
            if (file != null) {
                ins = new FileInputStream(file);
            } else {
                VFS vfs = this.shell.getVFS();
                FileName pwd = new FileName(this.shell.getEnvProperty("PWD"));
                FileName path = new FileName(vfile);
                if (path.isRelative()) {
                    path = pwd.absolutize(path);
                }
                path = vfs.resolve(this.shell.getUserCtx(), path, false);
                ins = new VFSInputStream(new SecureVFS(vfs, this.shell.getUserCtx()), path.toString());
            }
            reader = enc == null || enc.trim().length() == 0 ? new BufferedReader(new InputStreamReader(ins)) : new BufferedReader(new InputStreamReader((InputStream)ins, enc));
            isFile = true;
        } else {
            String lngName;
            args = params;
            BufferInputStream ins = new BufferInputStream(this.getStdIn());
            reader = enc == null || enc.trim().length() == 0 ? new BufferedReader(new InputStreamReader((InputStream)ins)) : new BufferedReader(new InputStreamReader((InputStream)ins, enc));
            langName = reader.readLine();
            if (langName.length() > 2) {
                langName = langName.substring(2).trim();
            }
            if ((lngName = sc.getLanguageForName(langName)) == null) {
                if (this.canThrowEx()) {
                    throw new RuntimeException("Scripting language is not supported: " + langName);
                }
                err.println("Scripting language is not supported: " + langName);
                return;
            }
            langName = lngName;
        }
        BSFManager manager = sc.getManager(langName);
        inStream = this.getStdInStream();
        outStream = this.getStdOutStream();
        context = this.shell.getContext();
        props = this.shell.getEnvProperties();
        out = new PrintWriter((Writer)new BufferedWriter((Writer)new BufferWriter(this.getStdOut())), true);
        in = new BufferedReader((Reader)new BufferReader(this.getStdIn()));
        InBuffer stdin = this.getStdIn();
        OutBuffer stdout = this.getStdOut();
        manager.declareBean("args", (Object)args, args.getClass());
        manager.declareBean("shell", (Object)this.shell, this.shell.getClass());
        manager.declareBean("instream", (Object)inStream, inStream.getClass());
        manager.declareBean("outstream", (Object)outStream, outStream.getClass());
        manager.declareBean("context", (Object)context, context.getClass());
        manager.declareBean("props", (Object)props, props.getClass());
        manager.declareBean("out", (Object)out, out.getClass());
        manager.declareBean("cin", (Object)in, in.getClass());
        manager.declareBean("stdin", (Object)stdin, stdin.getClass());
        manager.declareBean("stdout", (Object)stdout, stdout.getClass());
        manager.declareBean("console", (Object)System.out, System.out.getClass());
        log.debug((Object)("Info: Scripting language: " + langName));
        try {
            manager.exec(langName, fname, isFile ? 1 : 2, 0, (Object)IOUtils.readerToString((Reader)reader, (int)50000));
        }
        catch (BSFException ex) {
            Throwable e = ex;
            Throwable cause = ex.getTargetException();
            if (cause != null) {
                e = cause;
            }
            if (this.canThrowEx()) {
                log.error((Object)ex.getMessage(), e);
                this.wrapup(in, inStream, reader, out, outStream, manager);
                throw new RuntimeException("Exception while executing a script: ", e);
            }
            Throwable t = e.getCause();
            err.println("Exception while executing a script: " + e + " (" + (t != null ? String.valueOf(t) : "") + ")");
            this.wrapup(in, inStream, reader, out, outStream, manager);
            return;
        }
        catch (Throwable ex) {
            if (this.canThrowEx()) {
                log.error((Object)ex.getMessage(), ex);
                this.wrapup(in, inStream, reader, out, outStream, manager);
                throw new RuntimeException("Exception while executing a script: ", ex);
            }
            err.println("Exception while executing a script: " + ex.toString() + " (" + (ex.getCause() != null ? ex.getCause().toString() : "") + ")");
            this.wrapup(in, inStream, reader, out, outStream, manager);
            return;
        }
        this.wrapup(in, inStream, reader, out, outStream, manager);
        log.debug((Object)"done");
    }

    private void wrapup(Reader in, BufferInputStream inStream, Reader reader, Writer out, BufferOutputStream outStream, BSFManager manager) {
        try {
            in.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            inStream.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            reader.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            out.flush();
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            outStream.flush();
        }
        catch (Exception ex) {
            // empty catch block
        }
        manager.terminate();
    }

    private void printHelp() {
        PrintWriter out = new PrintWriter((Writer)new BufferWriter(this.getStdOut()));
        out.print("Usage: script [-ex] [--help] [-f/--file | -v/--vfile] SCRIPTFILENAME\n");
        out.print("\t\tExcutable for runing scripts\n");
        out.print("\t\t--help : this help\n");
        out.print("\t -f/--file : read from native filesystem\n");
        out.print("                Usage examples:\n");
        out.print("                     script arg1 arg2 &< stream\n");
        out.print("                     script -v javascriptFile.js arg1 arg2\n");
        out.print("                     script -f javascriptFile.js arg1 arg2\n");
        out.print("\n");
        out.print("Available variables:\n");
        out.print("    args      ...  array of String - CLI parameters\n");
        out.print("    shell     ...  org.jboss.fresh.shell.impl.ShellImpl\n");
        out.print("    instream  ...  java.io.InputStream wrapped around stdin\n");
        out.print("    outstream ...  java.io.OutputStream wrapped around stdout\n");
        out.print("    context   ...  org.jboss.fresh.ctx.Context - shell.getContext()\n");
        out.print("    props     ...  java.util.Properties - shell.getEnvProperties()\n");
        out.print("    out       ...  java.io.PrintWriter - wrapped around stdout\n");
        out.print("    cin       ...  java.io.BufferedReader - wrapped around stdin\n");
        out.print("    stdin     ...  org.jboss.fresh.io.InBuffer\n");
        out.print("    stdout    ...  org.jboss.fresh.io.OutBuffer\n");
        out.print("    console   ...  java.lang.System.out - java.io.PrintStream\n");
        out.print("\n");
        out.print("NOTE: -If using a script file scripting language is determined by extension!\n");
        out.print("      -If using a stream scripting language is determined by the first line!\n\n");
        out.close();
        log.debug((Object)"done");
    }
}

