package org.jboss.fresh.vfs;

import java.io.IOException;


public class VFSException extends IOException {

    public VFSException() {
        super();
    }

    public VFSException(String msg) {
        super(msg);
    }

    public VFSException(Throwable t) {
        super(t.getMessage());
		  initCause(t);
    }

	public VFSException(String msg, Throwable t) {
		 super(msg);
		 initCause(t);
	}

    public void setUnderlyingThrowable(Throwable t) {
		 initCause(t);
    }

    public Throwable getUnderlyingThrowable() {
       return getCause();
    }

    public String getMessage() {
        String retstr = super.getMessage();
        if (getCause() == null)
            return retstr;
        else
            return retstr + " Root exception is: " + getCause().toString();
    }

}