package org.jboss.fresh.vfs;


public interface VFSStore {

    /**
     *  Set the cache updater - listener that keeps the cache fresh.
     *
     * @param  updater  The cache updater.
     */
    public void setCacheUpdater(VFSStoreCacheUpdater updater);

    /**
     *  Get the cache updater;.
     *
     * @return          Wanted cache updater.
     */
    public VFSStoreCacheUpdater getCacheUpdater();

    /**
     *  FileName must not be null, it can point to inexisting file.
     */
    public boolean hasContent(FileName filename) throws Exception;

    /**
     *  Reads a chunk of content data and returns it as FileRetInfo object.
     *  FileOpInfo must be filled filename (file must exist), filepos and buf.
     */
    public FileReadInfo readContent(FileOpInfo opinfo) throws Exception;

    /**
     *  Writes a chunk of content data. FileOpInfo must be filled filename (file
     *  doesn't need to exist), filepos, and len.
     */
    public void writeContent(FileOpInfo opinfo) throws Exception;

    /**
     *  Removes content data for specified file from persistence.
     */
    public void removeContent(FileName name) throws Exception;

    /**
     *  Renames contents filename
     */
    public void rename(FileName oldPath, FileName newPath) throws Exception;

}
