package org.jboss.fresh.vfs.impl;

import org.jboss.fresh.cache.HierarchicalCache;
import org.jboss.fresh.cache.HierarchicalCacheImpl;
import org.jboss.fresh.vfs.FileInfo;
import org.jboss.fresh.vfs.FileName;
import org.jboss.fresh.vfs.TagFactory;
import org.jboss.fresh.vfs.UserCtx;
import org.jboss.fresh.vfs.VFSException;
import org.jboss.fresh.vfs.VFSMeta;
import org.jboss.fresh.vfs.VFSStore;
import org.apache.log4j.Logger;

import java.util.List;


public class CachedDefaultVFS extends DefaultVFS {

	public VFSCacheWrapper cache;

	private static Logger log = Logger.getLogger(CachedDefaultVFS.class);

	public CachedDefaultVFS(VFSMeta meta, VFSStore store, TagFactory tags) {
		this(new HierarchicalCacheImpl(), meta, store, tags);
	}

	public CachedDefaultVFS(HierarchicalCache c, VFSMeta meta, VFSStore store, TagFactory tags) {
		super(meta, store, tags);
		cache = new VFSCacheWrapper(c);
		meta.setCacheUpdater(cache);
		store.setCacheUpdater(cache);
	}


	protected FileName resolve(FileName filename, boolean partial) throws Exception {
		//log.debug( "[XXXXXXXXXXXXXXXXXX] resolve : " + filename + ", PARTIAL = " + partial );
		// log.trace("/vfs/cache", "filename: " + filename + ", PARTIAL = " + partial);

		FileName result = null;

		if (filename.toString().equals("/"))
			return filename;

		FileName parent = filename.getPath();
		String name = filename.getName();
		List[] fromCache;

		if (partial) {
			fromCache = cache.resolve(parent, true);
			if (fromCache != null)
				result = ((FileName) fromCache[0].get(1)).absolutize(name);

		} else {
			fromCache = cache.resolve(filename, true);
			if (fromCache != null)
				result = (FileName) fromCache[0].get(1);
		}

		if (fromCache == null)
			result = super.resolve(filename, partial);

		//log.debug( "[CachedDefaultVFS] [XXXXXXXXXXXX] Resolution is " + result );
		// log.trace("/vfs/cache", "Resolution is " + result);
		return result;
	}


	/**
	 *  VFSConfig METHODS *******************
	 *
	 * @param  meta  The new meta value
	 */

	public void setMeta(VFSMeta meta) {
		meta.setCacheUpdater(cache);
		super.setMeta(meta);
	}


	public void setStore(VFSStore store) {
		store.setCacheUpdater(cache);
		super.setStore(store);
	}


	public FileInfo getFileInfo(UserCtx ctx, FileName name, boolean direct) throws VFSException {

		//log.debug( "ZZZZZZZZZZZZZZZZZZZZZ getFileInfo( " + name + ", " + direct + " );" );
		// log.trace("/vfs/cache", "cachedVFS.getFileInfo( " + name + ", " + direct + " );");

		FileInfo result;

		try {
			name = resolve(name, direct);

			FileInfo[] fromCache = cache.getFileInfo(name);

			if (fromCache != null) {
				result = fromCache[0];
				//log.debug( "ZZZZZZZZZZZZZZZZZZZZZ fromCache = " + fromCache[0] );
				// log.trace("/vfs/cache", "fromCache = " + fromCache[0]);
			} else
				result = super.getFileInfo(ctx, name, direct);

		} catch (Exception e) {
			log.error(e.getMessage(), e);

			VFSException ve = new VFSException();

			ve.setUnderlyingThrowable(e);
			throw ve;
		}

		//log.debug( "ZZZZZZZZZZZZZZZZZZZZZ "  + result );
		// log.trace("/vfs/cache", "ZZZZZZZZZZZZZZZZZZZZZ");
		return result;
	}


	public boolean exists(UserCtx ctx, FileName name, boolean direct) throws VFSException {

		boolean result;
//log.debug( "ZZZZZZZZZZZZZZZZZZZZZ exists( " + name + ", " + direct + " );" );
		try {
			FileName file = resolve(name, direct);
			boolean[] fromCache = cache.exists(name);

			if (fromCache != null)
				result = fromCache[0];
			else
				result = super.exists(ctx, name, direct);

		} catch (Exception e) {
			VFSException ve = new VFSException();

			ve.setUnderlyingThrowable(e);
			throw ve;
		}

		return result;
	}


	public List list(UserCtx ctx, FileName name, boolean direct) throws VFSException {

		List result;
//log.debug( "ZZZZZZZZZZZZZZZZZZZZZ list( " + name + ", " + direct + " );" );
		try {
			List[] fromCache = cache.list(resolve(name, direct));

			if (fromCache != null)
				result = fromCache[0];
			else
				result = super.list(ctx, name, direct);

		} catch (Exception e) {
			VFSException ve = new VFSException();

			ve.setUnderlyingThrowable(e);
			throw ve;
		}

		return result;
	}

/*
	public List resolvePath( UserCtx uctx, FileName name ) throws VFSException {

		List result;

		try {
			List[] fromCache  = cache.resolve( name, false );

			if ( fromCache != null )
				result = fromCache[0];
			else
				result = super.resolvePath( uctx, name );

		} catch ( Exception e ) {
			VFSException ve  = new VFSException();

			ve.setUnderlyingThrowable( e );
			throw ve;
		}

		return result;
	}
*/

	public boolean hasContent(UserCtx uctx, FileName file, boolean direct) throws VFSException {
		boolean result;
//log.debug( "ZZZZZZZZZZZZZZZZZZZZZ hasContent( " + file + ", " + direct + " );" );
		try {
			file = resolve(file, direct);

			boolean[] fromCache = cache.hasContent(file);

			if (fromCache != null)
				result = fromCache[0];
			else
				result = super.hasContent(uctx, file, direct);

		} catch (Exception e) {
			VFSException ve = new VFSException();

			ve.setUnderlyingThrowable(e);
			throw ve;
		}

		return result;
	}
}
