package org.jboss.fresh.vfs.impl;

import org.jboss.fresh.vfs.*;

import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;


public class DefaultVFS implements VFS, VFSConfig, VFSAuth, java.io.Serializable {

    protected VFSMeta meta;
    protected VFSStore store;
    protected TagFactory tags;


    public DefaultVFS(VFSMeta meta, VFSStore store, TagFactory tags) {
        this.meta = meta;
        this.store = store;
        this.tags = tags;

        tags.init();
    }


    /********************  VFSAuth METHODS  ********************/

    public boolean isAuthorized(UserCtx uctx, String action, FileInfo fileinfo) {
        return true;
    }


    /********************  VFSConfig METHODS  ********************/

    public void setMeta(VFSMeta meta) {
        this.meta = meta;
    }


    public void setStore(VFSStore store) {
        this.store = store;
    }


    public void setTagFactory(TagFactory tags) {
        this.tags = tags;
    }


    /********************  VFS METHODS  ********************/

    public boolean exists(UserCtx ctx, FileName name, boolean direct) throws VFSException {

        try {
            FileName file = resolve(name, direct);
            return meta.exists(file);

        } catch (Exception e) {
/*
			VFSException ve = new VFSException();
			ve.setUnderlyingThrowable(e);
			throw ve;
*/
            return false;
        }
    }


    public FileInfo getFileInfo(UserCtx ctx, FileName name, boolean direct) throws VFSException {

        try {
            return meta.getFileInfo(resolve(name, direct));

        } catch (Exception e) {
            VFSException ve = new VFSException();
            ve.setUnderlyingThrowable(e);
            throw ve;
        }
    }


    public List list(UserCtx ctx, FileName name, boolean direct) throws VFSException {

        try {
            FileName path = null;

/*
			if (direct || name.isRoot())
				path = name;

			else {
				List paths = meta.resolvePath(name);
				path = (FileName)paths.get(paths.size()-1);
			}
*/
            path = resolve(name, direct);
            FileInfo parent = meta.getFileInfo(path);
            List listing;

            if ((parent == null) || !parent.isDirectory()) {
                listing = new LinkedList();
                if (parent != null)
                    listing.add(parent);

            } else {
                // tole dodajanje v extra je zelo potratno in ne scalable, ampak za testiranje bo zadostovalo
                listing = meta.list(path);
                /*Iterator it = listing.iterator();
                while (it.hasNext()) {
                    FileInfo curFile = (FileInfo)it.next();
                    if (curFile.isLink())
                        curFile.putExtra(meta.getFileInfo(curFile.getTarget()));
                }
                */
            }

            return listing;

        } catch (Exception e) {
            e.printStackTrace();
            VFSException ve = new VFSException();
            ve.setUnderlyingThrowable(e);
            throw ve;
        }
    }

/*
	public List resolvePath(UserCtx uctx, FileName name) throws VFSException {

		try {
			return meta.resolvePath(name);

		} catch (Exception e) {
			VFSException ve = new VFSException();
			ve.setUnderlyingThrowable(e);
			throw ve;
		}
	}
*/

    public String createFile(UserCtx ctx, FileInfo file) throws VFSException {

        try {
            if (meta.exists(file.getFileName()))
                throw new VFSException("Attempt to create file that already exists.");

            else if ((file.getFileName() == null) || ((file.getMime() == null) && file.isFile()) || (file.isLink() && (file.getTarget() == null)))
                throw new VFSException("Attempt to create file with name or mime being null.");

            else {
                String tag = tags.newTag();

                file.setFileName(resolve(file.getFileName(), true));
                file.setCreateDate(new Date());
                file.setLastModified(file.getCreateDate());
                file.setLength(0);
                file.setTag(tag);
                file.setComplete(true);
                //file.setOrderIndex(meta.countChildren(file.getFileName().getPath()));

                meta.create(file);
                return tag;
            }

        } catch (Exception e) {
            VFSException ve = new VFSException();
            ve.setUnderlyingThrowable(e);
            throw ve;
        }
    }


    public String updateFile(UserCtx ctx, FileInfo file) throws VFSException {

        try {
            if (!meta.exists(file.getFileName()))
                throw new VFSException("Attempt to create file that already exists.");

            else {
                String tag = tags.newTag();

                FileName path = resolve(file.getFileName(), true);
                file.setFileName(path);
                file.setLastModified(new Date());
                file.setTag(tag);

                meta.update(file);
                if ((file.getLength() == 0) && store.hasContent(path))
                    store.removeContent(path);

                return tag;
            }

        } catch (Exception e) {
            VFSException ve = new VFSException();
            ve.setUnderlyingThrowable(e);
            throw ve;
        }
    }


    public void remove(UserCtx uctx, FileName name, boolean direct) throws VFSException {

        try {
            FileName path = resolve(name, direct);
            meta.remove(path);

            //if ( recursive || store.hasContent(path) )
            store.removeContent(path);


        } catch (Exception e) {
            VFSException ve = new VFSException();
            ve.setUnderlyingThrowable(e);
            throw ve;
        }
    }


    public FileWriteInfo write(UserCtx uctx, FileOpInfo info) throws VFSException {

        try {
            String tag = tags.newTag();
            FileInfo file = meta.getFileInfo(info.filename);
            
            if(file == null) throw new NoSuchFileException(String.valueOf(info.filename));

            info.filename = file.getFileName();

            // set tag
            if (info.tag.equals(file.getTag()))
                file.setTag(tag);
            else
                throw new VFSException("Wrong filetag specified. Write operation not allowed.");

            // set length
            if (info.append) {
                long oldLength = file.getLength();
                long newLength = oldLength + info.buf.length;
                info.offset = oldLength;
                file.setLength(newLength);

            } else {
                file.setLength(info.buf.length);
                if (store.hasContent(info.filename))
                    store.removeContent(info.filename);
            }

            store.writeContent(info);
            FileWriteInfo result = new FileWriteInfo();
            result.tag = tag;
//			result.size = file.getLength();

            // set complete
            file.setComplete(info.complete);
            file.setLastModified(new Date());
            meta.update(file);

            return result;

        } catch (VFSException e) {
        	throw e;
        } catch (Exception e) {
            e.printStackTrace();
            VFSException ve = new VFSException();
            ve.initCause(e);
            throw ve;
        }
    }


    public FileReadInfo read(UserCtx uctx, FileOpInfo info) throws VFSException {

        try {
            FileInfo file = meta.getFileInfo(info.filename);
            if(file == null)
            	throw new NoSuchFileException(info.filename.toString());
            
            info.filename = file.getFileName();
            if (!store.hasContent(info.filename))
                return null;

            if ((info.offset != 0) && (!info.tag.equals(file.getTag())))
                throw new VFSException("Wrong filetag specified. Write operation not allowed.");

            FileReadInfo result = store.readContent(info);
            result.tag = file.getTag();
            return result;

        } catch (Exception e) {
            VFSException ve = new VFSException();
            ve.setUnderlyingThrowable(e);
            throw ve;
        }
    }


    public FileName resolve(UserCtx uctx, FileName filename, boolean partial) throws VFSException {
        try {
            return resolve(filename, partial);

        } catch (Exception e) {
            VFSException ve = new VFSException();
            ve.setUnderlyingThrowable(e);
            throw ve;
        }
    }


    public Collection getLinks(UserCtx uctx, FileName target, boolean direct) throws VFSException {
        try {
            target = resolve(target, direct);
            return meta.getLinks(target);

        } catch (Exception e) {
            VFSException ve = new VFSException();
            ve.setUnderlyingThrowable(e);
            throw ve;
        }

    }


    public boolean hasContent(UserCtx uctx, FileName file, boolean direct) throws VFSException {
        try {
            file = resolve(file, direct);
            return store.hasContent(file);

        } catch (Exception e) {
            VFSException ve = new VFSException();
            ve.setUnderlyingThrowable(e);
            throw ve;
        }
    }


    public void move(UserCtx uctx, FileName oldPath, FileName newPath, boolean direct) throws VFSException {
        try {
            oldPath = resolve(oldPath, direct);
            newPath = resolve(newPath, true);
            meta.rename(oldPath, newPath);

            //if (store.hasContent(oldPath))
            store.rename(oldPath, newPath);

        } catch (Exception e) {
            VFSException ve = new VFSException();
            ve.setUnderlyingThrowable(e);
            throw ve;
        }
    }


    public float moveBefore(UserCtx uctx, FileName file, FileName next) throws VFSException {
        try {
            return meta.moveBefore(file, next);

        } catch (Exception e) {
            VFSException ve = new VFSException();
            ve.setUnderlyingThrowable(e);
            throw ve;
        }
    }


    protected FileName resolve(FileName filename, boolean partial) throws Exception {
        FileName result;
        boolean full = !partial;

        if (filename.toString().equals("/"))
            return filename;

        FileName parent = filename.getPath();
        String name = filename.getName();

/*
		try {
			if (partial)
				result = meta.resolve(parent, 3).absolutize(name);

			else
				result = meta.resolve(filename, 3);

		} catch (Exception e) {
//System.out.println("Expected xception occured: " +e);
//			e.printStackTrace();
*/
        if (partial) {
            List l = meta.resolvePath(parent);
            result = ((FileName) l.get(l.size() - 1)).absolutize(name);

        } else {
            List l = meta.resolvePath(filename);
            result = ((FileName) l.get(l.size() - 1));
        }
//		}

        return result;
    }
}