package org.jboss.fresh.vfs.impl;

import org.jboss.fresh.vfs.*;

import java.io.IOException;
import java.io.OutputStream;

import org.apache.log4j.Logger;


public class VFSOutputStream extends OutputStream {

    private SecureVFS vfs;
    private FileName filename;
    private boolean append;
    private boolean closed;

    private boolean first = true;
    private String tag;

    private byte[] buff;
    private int tlen;

    private static Logger log = Logger.getLogger("org.jboss.fresh.vfs.impl.VFSOutputStream");

    public VFSOutputStream(SecureVFS vfs, String filename) throws IOException {
        this(vfs, filename, false);
    }

    public VFSOutputStream(SecureVFS vfs, String fname, boolean append) throws IOException {

        try {

            this.vfs = vfs;
            this.filename = new FileName(fname);
            this.append = append;

            // need to locate this file if it exists and not append overwrite it

            FileInfo info = vfs.getFileInfo(filename, false);
            //log.debug("[VFSOutputStream] <init> info: " + info);
            log.debug("/vfs/io "+"<init> info: " + info);
            // if it does not exist create an empty one
            if (info == null) { // file does not exist
                info = new FileInfo(filename, FileInfo.TYPE_FILE);
                info.setMime("x-application/octet-stream");
                //log.debug("[VFSOutputStream] <init> info: " + info);
                log.debug("/vfs/io"+"<init> info: " + info);
                //log.debug("[VFSOutputStream] creating file... " + info.getFileName());
                log.debug("/vfs/io"+ "creating file... " + info.getFileName());
                //log.debug("[VFSOutputStream] creating file with path " + info.getFileName().getPath());
                log.debug("/vfs/io"+ "creating file with path " + info.getFileName().getPath());
                tag = vfs.createFile(info);
                //log.debug("[VFSOutputStream] file created: " + tag);
                log.debug("/vfs/io"+ "file created: " + tag);
            } else {
                tag = info.getTag();
            }

        } catch (Throwable ex) {
            throw new VFSIOException(ex);
        }

    }


    public void close() throws IOException {
        if (closed) return;  // if it has already been flushed we must not do it again.
        closed = true;
        flush();
    }


    public void flush() throws IOException {
        // write what you have buffered
        // if nothing buffered, write nothing
        try {


            if (tlen == 0) return;
//log.debug("[VFSOutputStream] flush: tlen: " + tlen);
            // append to the current location there
            FileOpInfo inf = new FileOpInfo();
            inf.tag = tag;
            inf.filename = filename;

// DEBUG CODE >>>
// Check if file exists:
//		FileInfo finf=vfs.getFileInfo(filename, false);
//		if(finf==null) {
//			System.out.println("[VFSOutputStream] flush: File with a name " + filename + " does not exist.");
//		}
// <<<
            if (first && !append) { // here we decide weather to overwrite
                inf.append = false;
                first = false;
            } else {
                inf.append = true;
            }

            inf.complete = closed;

            byte[] bf;

            if (tlen != buff.length) {
                bf = new byte[tlen];
                System.arraycopy(buff, 0, bf, 0, tlen);
            } else {
                bf = buff;
            }

            inf.buf = bf;

            FileWriteInfo retinf = vfs.write(inf);
            tag = retinf.tag;

            tlen = 0;
        } catch (Throwable ex) {
            ex.printStackTrace();
            throw new VFSIOException(ex);
        }
    }

    // don't use this. Always wrap BufferedOutputStream around
    public void write(int b) throws IOException {
        write(new byte[]{(byte) b});
    }

    public void write(byte[] buf) throws IOException {
        write(buf, 0, buf.length);
    }

    public void write(byte[] buf, int off, int len) throws IOException {
        flush(); // flush previous one, save this one

        int sz;
        if (buff == null || buff.length < len) { // increase buffer if necessary
//log.debug("[VFSOutputStream] write: increasing buffer size.");

            if (buf.length > len)
                sz = buf.length;
            else
                sz = len;
            buff = new byte[sz];
        }

        System.arraycopy(buf, off, buff, 0, len);
//log.debug("[VFSOutputStream] write: copied " + len + " bytes to the buffer.");
        tlen = len;
    }
}