package org.jboss.fresh.vfs.impl.disk;

import org.jboss.fresh.vfs.VFSMeta;
import org.jboss.fresh.vfs.VFSStore;
import org.jboss.fresh.vfs.VFSStoreFactory;

import java.util.Properties;


public class DiskVFSStoreFactory implements VFSStoreFactory {

    public VFSStore create(VFSMeta meta, Properties p) throws Exception {
        if (p == null)
            p = System.getProperties();

        String fsroot = p.getProperty("diskfs.root", "");
        if("".equals(fsroot)) throw new RuntimeException("diskfs.root property not specified - it is required.");

        VFSStore store = new DiskVFSStore(meta, fsroot);

        return store;
    }

}