package org.jboss.fresh.vfs.impl.mem;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class FNode {

	public static final int FILE = 0;
	public static final int DIR = 1;
	public static final int LINK = 2;

	int type;
	String name;
	FNode parent;
	String link;
	FileContent content;
	HashMap attrs;
	Date createDate;
	Date lastModified;
	String mime;
	String tag;

	public String getName() {
		return name;
	}

	public void setName(String val) {
		name = val;
	}

	public void setType(int type) {
		this.type = type;
	}

	public String getLinkRef() {
		return link;
	}

	public int getType() {
		return type;
	}

	public void setLength(long len) {
		content.setLength(len);
	}

	public synchronized void setAttrs(Map attributes) {
		attrs = new HashMap(attributes);
	}

	public synchronized HashMap getAttrs() {
		if(attrs == null)
			attrs = new HashMap();
		return attrs;
	}

	public void setCreateDate(Date date) {
		createDate = date;
	}

	public Date getCreateDate() {
		return createDate;
	}

	public void setLastModified(Date date) {
		lastModified = date;
	}

	public Date getLastModified() {
		return lastModified;
	}

	public long getLength() {
		return content.getLength();
	}

	public void setMime(String mime) {
		this.mime = mime;
	}

	public String getMime() {
		return mime;
	}

	public void setLink(String link) {
		this.link = link;
	}

	public String getLink() {
		return link;
	}
	
	public FileContent getFileContent() {
		return content;
	}

	public void setFileContent(FileContent fc) {
		content = fc;
	}

	public void setTag(String tag) {
		this.tag = tag;
	}
	
	public String getTag() {
		return tag;
	}
}