package org.jboss.fresh.vfs.impl.mem;

import java.io.IOException;
import java.io.OutputStream;

public class MemOutputStream extends OutputStream {

	private FileContent fc;
	int pos = 0;

	/**
	 * 
	 */
	public MemOutputStream(FileContent fc) {
		super();
		this.fc = fc;
		fc.truncate(0);
	}

	/* (non-Javadoc)
	 * @see java.io.Closeable#close()
	 */
	public void close() throws IOException {
		pos = 0;
	}

	/* (non-Javadoc)
	 * @see java.io.Flushable#flush()
	 */
	public void flush() throws IOException {
		//fc.flush();
	}

	/* (non-Javadoc)
	 * @see java.io.OutputStream#write(byte[], int, int)
	 */
	public void write(byte[] b, int off, int len) throws IOException {
		fc.write(pos, b, off, len);
		pos += len;
	}

	/* (non-Javadoc)
	 * @see java.io.OutputStream#write(byte[])
	 */
	public void write(byte[] b) throws IOException {
		fc.write(pos, b, 0, b.length);
		pos += b.length;
	}

	/* (non-Javadoc)
	 * @see java.io.OutputStream#write(int)
	 */
	public void write(int b) throws IOException {
		fc.write(pos++, b);
	}

	private int seek(int pos) {
		int len = (int) fc.getLength();
		if(pos > len) return len;
		return pos;
	}

}
