package org.jboss.fresh.vfs.impl.mem;

import org.jboss.fresh.vfs.VFSMeta;
import org.jboss.fresh.vfs.VFSStore;
import org.jboss.fresh.vfs.VFSStoreFactory;

import java.util.Properties;


public class MemVFSStoreFactory implements VFSStoreFactory {

    public VFSStore create(VFSMeta meta, Properties p) throws Exception {
        if (p == null)
            p = System.getProperties();

        String fsname = p.getProperty("memfs.name", "");
        if("".equals(fsname)) throw new RuntimeException("memfs.name property not specified - it is used to specify a required VFS name");

        VFSStore store = new MemVFSStore(meta, fsname);

        return store;
    }

}