/*
 * Created on 23.11.2004
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.jboss.fresh.vfs.impl.mem;

import java.io.IOException;

/**
 * @author gospodar
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class RAF {

	FileContent fc;
	String enc;
	int pos = 0;

	public RAF(FileContent fc) {
		this.fc = fc;
	}

	public long getLength() {
		return fc.getLength();
	}

	public void write(byte [] val) {
		fc.write(pos, val, 0, val.length);
		pos += val.length;
	}

	public void write(byte [] val, int offs, int len) {
		fc.write(pos, val, offs, len);
		pos += len;
	}

	public void write(char [] val) throws IOException {
		write(val, 0, val.length);
	}

	public void write(char [] val, int offs, int len) throws IOException {
		if(enc!=null) write(new String(val, offs, len).getBytes(enc));
		else write(new String(val, offs, len).getBytes(enc));
	}

	public int read(byte [] val) {
		int rc = fc.read(pos, val, 0, val.length);
		pos += rc;
		return rc;
	}

	public int read(byte [] val, int offs, int len) {
		int rc = fc.read(pos, val, offs, len);
		pos += rc;
		return rc;
	}

	public int read(char [] val) throws IOException {
		return read(val, 0, val.length);
	}

	public int read(char [] val, int offs, int len) throws IOException {
		byte [] buf = new byte [len];
		int rc = fc.read(pos, buf, 0, len);
		pos += rc;
		if(enc!=null) System.arraycopy(new String(buf, 0, rc, enc), 0, val, offs, rc);
		else System.arraycopy(new String(buf, 0, rc), 0, val, offs, rc);
		return rc;
	}

/*	public void flush() {
		fc.flush();
	}
*/
	public long seek(long offset) {
		//fc.seek(offset);
		long ln = getLength();
		if(offset > ln)
			pos = (int) ln;
		else
			pos = (int) offset;

		return pos;
	}

	public void close() {
		pos = 0;
	}
	
	public void truncate(long size) {
		fc.truncate(size);
	}
}
