/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.api.test;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.jboss.galleon.BaseErrors;
import org.jboss.galleon.DefaultMessageWriter;
import org.jboss.galleon.MessageWriter;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.ProvisioningManager;
import org.jboss.galleon.api.GalleonBuilder;
import org.jboss.galleon.api.Provisioning;
import org.jboss.galleon.api.config.GalleonProvisioningConfig;
import org.jboss.galleon.api.test.util.TestUtils;
import org.jboss.galleon.creator.FeaturePackCreator;
import org.jboss.galleon.repo.RepositoryArtifactResolver;
import org.jboss.galleon.state.ProvisionedState;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.UniverseSpec;
import org.jboss.galleon.universe.galleon1.LegacyGalleon1RepositoryManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public class FeaturePackRepoTestBase {
    protected Path workDir;
    protected Path repoHome;
    protected Path installHome;
    private Path tmpDir;
    protected RepositoryArtifactResolver repo;
    protected FeaturePackCreator creator;
    private boolean recordState = true;

    @Before
    public void before() throws Exception {
        this.workDir = TestUtils.mkRandomTmpDir();
        this.installHome = TestUtils.mkdirs(this.workDir, "dist");
        this.repoHome = TestUtils.mkdirs(this.workDir, "repo");
        this.repo = this.initRepoManager(this.repoHome);
        this.doBefore();
    }

    protected void doBefore() throws Exception {
    }

    @After
    public void after() throws Exception {
        this.doAfter();
    }

    protected void doAfter() throws Exception {
    }

    protected void setRecordState(boolean recordState) {
        this.recordState = recordState;
    }

    protected boolean isRecordState() {
        return this.recordState;
    }

    protected RepositoryArtifactResolver initRepoManager(Path repoHome) {
        return LegacyGalleon1RepositoryManager.newInstance((Path)repoHome);
    }

    protected FeaturePackCreator initCreator() throws ProvisioningException {
        return (FeaturePackCreator)FeaturePackCreator.getInstance().addArtifactResolver(this.repo);
    }

    protected MessageWriter getMessageWriter() {
        return new DefaultMessageWriter();
    }

    protected Provisioning getPm() throws ProvisioningException {
        GalleonBuilder provider = new GalleonBuilder();
        provider.addArtifactResolver(this.repo);
        return provider.newProvisioningBuilder().setInstallationHome(this.installHome).setRecordState(this.recordState).setMessageWriter(this.getMessageWriter()).build();
    }

    protected ProvisioningManager getCorePm() throws ProvisioningException {
        return ProvisioningManager.builder().setInstallationHome(this.installHome).build();
    }

    protected Path resolve(String relativePath) {
        return this.installHome.resolve(relativePath);
    }

    protected static void assertProvisioningConfig(Provisioning pm, GalleonProvisioningConfig config) throws ProvisioningException {
        Assert.assertEquals((Object)config, (Object)pm.getProvisioningConfig());
    }

    protected void assertProvisionedState(ProvisioningManager pm, ProvisionedState config) throws ProvisioningException {
        Assert.assertEquals((Object)config, (Object)pm.getProvisionedState());
    }

    protected Path getTmpDir() throws ProvisioningException {
        try {
            return this.tmpDir == null ? (this.tmpDir = Files.createDirectory(this.workDir.resolve("tmp"), new FileAttribute[0])) : this.tmpDir;
        }
        catch (IOException e) {
            throw new ProvisioningException(BaseErrors.mkdirs((Path)this.workDir.resolve("tmp")), (Throwable)e);
        }
    }

    protected FeaturePackLocation newFpl(String producer, String universe, String channel, String frequency, String build) {
        return new FeaturePackLocation(new UniverseSpec(universe, null), producer, channel, frequency, build);
    }
}

