/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.api;

import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.jboss.galleon.CoreVersion;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.api.GalleonBuilder;
import org.jboss.galleon.api.Provisioning;
import org.jboss.galleon.api.config.GalleonProvisioningConfig;
import org.jboss.galleon.api.test.FeaturePackRepoTestBase;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.config.FeatureConfig;
import org.jboss.galleon.creator.FeaturePackCreator;
import org.jboss.galleon.spec.ConfigLayerSpec;
import org.jboss.galleon.spec.FeatureParameterSpec;
import org.jboss.galleon.spec.FeatureReferenceSpec;
import org.jboss.galleon.spec.FeatureSpec;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.galleon1.LegacyGalleon1Universe;
import org.jboss.galleon.util.ZipUtils;
import org.junit.Assert;
import org.junit.Test;

public class GreaterVersionTestCase
extends FeaturePackRepoTestBase {
    private static final FeaturePackLocation.FPID FP1_100_GAV = LegacyGalleon1Universe.newFPID((String)"org.jboss.pm.test:fp1", (String)"1", (String)"1.0.0.Final");

    @Override
    protected void doBefore() throws Exception {
        super.doBefore();
        FeaturePackCreator fpCreator = this.initCreator();
        this.createFeaturePacks(fpCreator);
        fpCreator.install();
    }

    @Test
    public void testOlderVersion() throws Exception {
        GalleonProvisioningConfig config;
        GalleonBuilder builder = new GalleonBuilder();
        builder.addArtifactResolver(this.repo);
        Path fp = this.workDir.resolve("repo/org/jboss/pm/test/fp1/1.0.0.Final/fp1-1.0.0.Final.zip");
        Path unzipped = this.workDir.resolve("unzipped");
        Files.createDirectory(unzipped, new FileAttribute[0]);
        ZipUtils.unzip((Path)fp, (Path)unzipped);
        Path fpDesc = unzipped.resolve("feature-pack.xml");
        String content = Files.readString(fpDesc);
        String patched = content.replace("galleon-min-version=\"" + CoreVersion.getVersion() + "\"", "galleon-min-version=\"9999.0.0.Final\"");
        Files.write(fpDesc, patched.getBytes(), new OpenOption[0]);
        Files.delete(fp);
        ZipUtils.zip((Path)unzipped, (Path)fp);
        try (Provisioning p = builder.newProvisioningBuilder().setInstallationHome(this.installHome).build();){
            p.provision(((GalleonProvisioningConfig.Builder)GalleonProvisioningConfig.builder().addFeaturePackDep(FP1_100_GAV.getLocation())).build());
            config = p.getProvisioningConfig();
        }
        try {
            Provisioning p2 = builder.newProvisioningBuilder(config).build();
            try {
                throw new Exception("Should have failed");
            }
            catch (Throwable throwable) {
                if (p2 != null) {
                    try {
                        p2.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (ProvisioningException ex) {
            Assert.assertTrue((boolean)ex.getLocalizedMessage().contains("Artifact org.jboss.galleon:galleon-core:jar:9999.0.0.Final not found in the repository"));
            return;
        }
    }

    protected void createFeaturePacks(FeaturePackCreator creator) throws ProvisioningException {
        creator.newFeaturePack(FP1_100_GAV).addFeatureSpec(((FeatureSpec.Builder)FeatureSpec.builder((String)"specA").addParam(FeatureParameterSpec.createId((String)"name")).addParam(FeatureParameterSpec.create((String)"a", (boolean)true)).addPackageDep("specA.pkg")).build()).addFeatureSpec(((FeatureSpec.Builder)FeatureSpec.builder((String)"specB").addParam(FeatureParameterSpec.createId((String)"name")).addParam(FeatureParameterSpec.create((String)"a", (boolean)true)).addFeatureRef(FeatureReferenceSpec.builder((String)"specA").setName("specA").setNillable(false).mapParam("a", "name").build()).addPackageDep("specB.pkg")).build()).addConfigLayer(((ConfigLayerSpec.Builder)((ConfigLayerSpec.Builder)ConfigLayerSpec.builder().setModel("model1").setName("base")).addFeature(new FeatureConfig("specA").setParam("name", "base-prod1").setParam("a", "base"))).build()).addConfig(((ConfigModel.Builder)((ConfigModel.Builder)((ConfigModel.Builder)ConfigModel.builder().setName("main")).setModel("model1").setProperty("prop1", "value1").setProperty("prop2", "value2").addFeature(new FeatureConfig("specB").setParam("name", "b").setParam("a", "a"))).addFeature(new FeatureConfig("specA").setParam("name", "a"))).build(), true).newPackage("p1", true).getFeaturePack().newPackage("specA.pkg").getFeaturePack().newPackage("specB.pkg").addDependency("p2").getFeaturePack().newPackage("p2").getFeaturePack();
    }
}

