/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.api.test.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import org.jboss.galleon.util.IoUtils;

public class TestUtils {
    private static void mkdirs(Path dir) {
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create dir " + dir);
        }
    }

    public static Path mkRandomTmpDir() {
        return IoUtils.createTmpDir((String)UUID.randomUUID().toString());
    }

    public static void rm(Path p) {
        IoUtils.recursiveDelete((Path)p);
    }

    public static Path mkdirs(Path dir, String ... name) {
        if (!Files.exists(dir, new LinkOption[0])) {
            TestUtils.mkdirs(dir);
        }
        Path p = dir;
        for (String n : name) {
            p = p.resolve(n);
            try {
                Files.createDirectory(p, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to create dir " + dir);
            }
        }
        return p;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String read(Path p) {
        StringWriter strWriter = new StringWriter();
        try (BufferedReader reader = Files.newBufferedReader(p);){
            BufferedWriter writer;
            block16: {
                String string;
                writer = new BufferedWriter(strWriter);
                try {
                    String line = reader.readLine();
                    if (line == null) break block16;
                    writer.write(line);
                    line = reader.readLine();
                    while (line != null) {
                        writer.newLine();
                        writer.write(line);
                        line = reader.readLine();
                    }
                    writer.flush();
                    string = strWriter.getBuffer().toString();
                }
                catch (Throwable throwable) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                writer.close();
                return string;
            }
            String string = null;
            writer.close();
            return string;
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read " + p, e);
        }
    }
}

