/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.api.test.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.jboss.galleon.xml.XmlParser;
import org.junit.Assert;
import org.xml.sax.SAXException;

public class XmlParserValidator<T> {
    private final Validator validator;
    private final XmlParser<T> parser;

    public XmlParserValidator(Path schemaPath, XmlParser<T> parser) {
        this.parser = parser;
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try (BufferedReader r = Files.newBufferedReader(schemaPath, Charset.forName("utf-8"));){
            Schema schema = schemaFactory.newSchema(new StreamSource(r));
            this.validator = schema.newValidator();
        }
        catch (IOException | SAXException e) {
            throw new RuntimeException(e);
        }
    }

    public void validate(Path p) throws SAXException, IOException {
        try (BufferedReader reader = Files.newBufferedReader(p, Charset.forName("utf-8"));){
            this.validator.validate(new StreamSource(reader));
        }
    }

    public T validateAndParse(String resourcePath) throws Exception {
        return this.validateAndParse(resourcePath, null, null);
    }

    public T validateAndParse(Path p) throws Exception {
        return this.validateAndParse(p, null, null);
    }

    public T validateAndParse(String resourcePath, String xsdValidationExceptionMessage, String parseExceptionMessage) throws Exception {
        Path p = XmlParserValidator.getResource(resourcePath);
        return this.validateAndParse(p, xsdValidationExceptionMessage, parseExceptionMessage);
    }

    public T validateAndParse(Path p, String xsdValidationExceptionMessage, String parseExceptionMessage) throws Exception {
        try {
            this.validate(p);
            if (xsdValidationExceptionMessage != null) {
                Assert.fail((String)("Schema validation passed while expected to fail with the error: " + xsdValidationExceptionMessage));
            }
        }
        catch (SAXException e) {
            if (xsdValidationExceptionMessage == null) {
                throw e;
            }
            Assert.assertTrue((boolean)e.getMessage().contains(xsdValidationExceptionMessage));
        }
        return this.parse(p, parseExceptionMessage);
    }

    public T parse(Path p) throws Exception {
        return this.parse(p, null);
    }

    public T parse(Path p, String parseExceptionMessage) throws Exception {
        Object result = null;
        try (BufferedReader reader = Files.newBufferedReader(p, Charset.forName("utf-8"));){
            result = this.parser.parse((Reader)reader);
            if (parseExceptionMessage != null) {
                Assert.fail((String)("Parsing succeeded while expected to fail with the error: " + parseExceptionMessage));
            }
        }
        catch (XMLStreamException e) {
            String m = String.format("[%s] should contain [%s]", e.getMessage(), parseExceptionMessage);
            if (parseExceptionMessage == null) {
                Assert.fail((String)e.getMessage());
            }
            Assert.assertTrue((String)m, (boolean)e.getMessage().contains(parseExceptionMessage));
        }
        return (T)result;
    }

    private static Path getResource(String path) {
        URL resUrl = Thread.currentThread().getContextClassLoader().getResource(path);
        Assert.assertNotNull((String)("Resource " + path + " is not on the classpath"), (Object)resUrl);
        try {
            return Paths.get(resUrl.toURI());
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Failed to get URI from URL", e);
        }
    }
}

