/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.api;

import java.net.URLClassLoader;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.galleon.CoreVersion;
import org.jboss.galleon.DefaultMessageWriter;
import org.jboss.galleon.MessageWriter;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.api.APIVersion;
import org.jboss.galleon.api.GalleonBuilder;
import org.jboss.galleon.api.test.FeaturePackRepoTestBase;
import org.jboss.galleon.creator.FeaturePackCreator;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.galleon1.LegacyGalleon1Universe;
import org.junit.Assert;
import org.junit.Test;

public class GalleonBuilderTestCase
extends FeaturePackRepoTestBase {
    private static final FeaturePackLocation.FPID FP1_100_GAV = LegacyGalleon1Universe.newFPID((String)"org.jboss.pm.test:fp1", (String)"1", (String)"1.0.0.Final");
    private final MessageWriter log = new DefaultMessageWriter();

    @Override
    protected void doBefore() throws Exception {
        super.doBefore();
        FeaturePackCreator fpCreator = this.initCreator();
        this.createFeaturePacks(fpCreator);
        fpCreator.install();
    }

    @Test
    public void test() throws Exception {
        GalleonBuilder builder = new GalleonBuilder();
        builder.addArtifactResolver(this.repo);
        Assert.assertEquals((long)GalleonBuilder.getClassLoaders().size(), (long)0L);
        final AtomicReference<Object> msg = new AtomicReference<Object>(null);
        GalleonBuilder.releaseUsage((String)CoreVersion.getVersion(), (MessageWriter)new DefaultMessageWriter(){

            public void verbose(CharSequence message) {
                msg.set(message.toString());
            }
        });
        Assert.assertEquals((Object)("Releasing usage of core " + CoreVersion.getVersion() + " although no usage"), msg.get());
        URLClassLoader l1 = GalleonBuilder.getCallerClassLoader((String)APIVersion.getVersion(), null);
        Assert.assertEquals((long)GalleonBuilder.getClassLoaders().size(), (long)1L);
        URLClassLoader l2 = GalleonBuilder.getCallerClassLoader((String)APIVersion.getVersion(), null);
        Assert.assertEquals((Object)l1, (Object)l2);
        Assert.assertEquals((long)GalleonBuilder.getClassLoaders().size(), (long)1L);
        URLClassLoader l3 = GalleonBuilder.getCallerClassLoader((String)CoreVersion.getVersion(), null);
        Assert.assertEquals((Object)l1, (Object)l3);
        Assert.assertEquals((long)GalleonBuilder.getClassLoaders().size(), (long)1L);
        GalleonBuilder.releaseUsage((String)CoreVersion.getVersion(), (MessageWriter)this.log);
        GalleonBuilder.releaseUsage((String)CoreVersion.getVersion(), (MessageWriter)this.log);
        GalleonBuilder.releaseUsage((String)CoreVersion.getVersion(), (MessageWriter)this.log);
        Assert.assertEquals((long)GalleonBuilder.getClassLoaders().size(), (long)0L);
        URLClassLoader l4 = GalleonBuilder.getCallerClassLoader((String)CoreVersion.getVersion(), null);
        Assert.assertNotEquals((Object)l1, (Object)l4);
        Assert.assertEquals((long)GalleonBuilder.getClassLoaders().size(), (long)1L);
        URLClassLoader loader = builder.getCoreClassLoader(CoreVersion.getVersion());
        Assert.assertNotNull((Object)loader);
        URLClassLoader loader2 = builder.getCoreClassLoader(APIVersion.getVersion());
        Assert.assertNotNull((Object)loader2);
        Assert.assertEquals((Object)loader, (Object)loader2);
        Assert.assertEquals((long)GalleonBuilder.getClassLoaders().size(), (long)1L);
        GalleonBuilder.releaseUsage((String)CoreVersion.getVersion(), (MessageWriter)this.log);
        GalleonBuilder.releaseUsage((String)CoreVersion.getVersion(), (MessageWriter)this.log);
        GalleonBuilder.releaseUsage((String)CoreVersion.getVersion(), (MessageWriter)this.log);
        try {
            builder.getCoreClassLoader("foo");
            throw new Exception();
        }
        catch (ProvisioningException provisioningException) {
            Assert.assertEquals((Object)APIVersion.getVersion(), (Object)builder.getCoreVersion(FP1_100_GAV.getLocation()));
            return;
        }
    }

    protected void createFeaturePacks(FeaturePackCreator creator) throws ProvisioningException {
        creator.newFeaturePack(FP1_100_GAV);
    }
}

