/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.arquillian.container;

import java.util.ArrayList;
import java.util.List;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.spi.context.ObjectStore;
import org.jboss.arquillian.test.spi.context.ClassContext;
import org.jboss.arquillian.test.spi.context.SuiteContext;
import org.jboss.arquillian.test.spi.event.suite.AfterClass;
import org.jboss.arquillian.test.spi.event.suite.AfterSuite;
import org.jboss.arquillian.test.spi.event.suite.BeforeClass;
import org.jboss.arquillian.test.spi.event.suite.BeforeSuite;
import org.jboss.gravia.arquillian.container.ContainerSetup;
import org.jboss.gravia.arquillian.container.SetupTask;

public class SetupObserver<T extends SetupTask> {
    @Inject
    private Instance<SuiteContext> suiteContextInstance;
    @Inject
    private Instance<ClassContext> classContextInstance;

    public List<T> getSetupTasks() throws Exception {
        ObjectStore objectStore;
        TaskList taskList = null;
        ClassContext classContext = (ClassContext)this.classContextInstance.get();
        if (classContext.isActive() && (taskList = (TaskList)(objectStore = classContext.getObjectStore()).get(TaskList.class)) == null) {
            taskList = new TaskList();
            Class currentClass = (Class)classContext.getActiveId();
            ContainerSetup setup = currentClass.getAnnotation(ContainerSetup.class);
            if (setup != null) {
                Class<? extends SetupTask>[] classes;
                for (Class<? extends SetupTask> clazz : classes = setup.value()) {
                    taskList.add(clazz.newInstance());
                }
            }
            classContext.getObjectStore().add(TaskList.class, taskList);
            ObjectStore suiteStore = this.getSuiteObjectStore();
            ((TaskList)suiteStore.get(TaskList.class)).addAll(taskList);
        }
        return taskList != null ? taskList : new TaskList();
    }

    protected <C extends SetupTask.SetupContext> C getSetupContext(ObjectStore suiteStore, ObjectStore classStore) {
        return (C)new AbstractSetupContext(suiteStore, classStore);
    }

    protected ObjectStore getSuiteObjectStore() {
        SuiteContext suiteContext = (SuiteContext)this.suiteContextInstance.get();
        return suiteContext.getObjectStore();
    }

    public void handleBeforeSuite(@Observes BeforeSuite event) throws Throwable {
        ObjectStore objectStore = this.getSuiteObjectStore();
        objectStore.add(TaskList.class, new TaskList());
    }

    public void handleBeforeClass(@Observes BeforeClass event) throws Throwable {
        List<T> setupTasks = this.getSetupTasks();
        if (!setupTasks.isEmpty()) {
            ClassContext classContext = (ClassContext)this.classContextInstance.get();
            ObjectStore suiteStore = ((SuiteContext)this.suiteContextInstance.get()).getObjectStore();
            ObjectStore classStore = classContext.getObjectStore();
            Object context = this.getSetupContext(suiteStore, classStore);
            for (SetupTask task : setupTasks) {
                task.beforeClass((SetupTask.SetupContext)context);
            }
        }
    }

    public void handleAfterClass(@Observes AfterClass event) throws Throwable {
        List<T> setupTasks = this.getSetupTasks();
        if (!setupTasks.isEmpty()) {
            ClassContext classContext = (ClassContext)this.classContextInstance.get();
            ObjectStore classStore = classContext.getObjectStore();
            ObjectStore suiteStore = ((SuiteContext)this.suiteContextInstance.get()).getObjectStore();
            Object context = this.getSetupContext(suiteStore, classStore);
            for (SetupTask task : setupTasks) {
                task.afterClass((SetupTask.SetupContext)context);
            }
        }
    }

    public void handleAfterSuite(@Observes AfterSuite event) throws Throwable {
        SuiteContext suiteContext = (SuiteContext)this.suiteContextInstance.get();
        TaskList setupTasks = (TaskList)suiteContext.getObjectStore().get(TaskList.class);
        if (!setupTasks.isEmpty()) {
            ObjectStore suiteStore = suiteContext.getObjectStore();
            AbstractSetupContext context = new AbstractSetupContext(suiteStore, null);
            for (SetupTask task : setupTasks) {
                task.afterSuite(context);
            }
        }
    }

    public static class AbstractSetupContext
    implements SetupTask.SetupContext {
        private final ObjectStore suiteStore;
        private final ObjectStore classStore;

        public AbstractSetupContext(ObjectStore suiteStore, ObjectStore classStore) {
            this.suiteStore = suiteStore;
            this.classStore = classStore;
        }

        @Override
        public ObjectStore getSuiteStore() {
            return this.suiteStore;
        }

        @Override
        public ObjectStore getClassStore() {
            return this.classStore;
        }
    }

    private static class TaskList<T extends SetupTask>
    extends ArrayList<T> {
        private TaskList() {
        }
    }
}

