/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.arquillian.container.embedded;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.jboss.gravia.provision.ResourceHandle;
import org.jboss.gravia.provision.ResourceInstaller;
import org.jboss.gravia.provision.spi.AbstractResourceInstaller;
import org.jboss.gravia.provision.spi.RuntimeEnvironment;
import org.jboss.gravia.repository.DefaultRepositoryXMLReader;
import org.jboss.gravia.repository.Repository;
import org.jboss.gravia.resource.Attachable;
import org.jboss.gravia.resource.DefaultResourceBuilder;
import org.jboss.gravia.resource.Resource;
import org.jboss.gravia.resource.ResourceContent;
import org.jboss.gravia.resource.ResourceIdentity;
import org.jboss.gravia.runtime.Module;
import org.jboss.gravia.runtime.ModuleContext;
import org.jboss.gravia.runtime.ModuleException;
import org.jboss.gravia.runtime.Runtime;
import org.jboss.gravia.runtime.RuntimeLocator;
import org.jboss.gravia.runtime.ServiceLocator;
import org.jboss.gravia.runtime.embedded.internal.EmbeddedRuntime;
import org.jboss.gravia.runtime.spi.ClassLoaderEntriesProvider;
import org.jboss.gravia.runtime.spi.DefaultPropertiesProvider;
import org.jboss.gravia.runtime.spi.ManifestHeadersProvider;
import org.jboss.gravia.runtime.spi.ModuleEntriesProvider;
import org.jboss.gravia.runtime.spi.PropertiesProvider;
import org.jboss.gravia.runtime.spi.RuntimeFactory;
import org.jboss.gravia.runtime.spi.URLStreamHandlerFactoryProxy;
import org.jboss.gravia.runtime.spi.URLStreamHandlerTracker;
import org.jboss.gravia.utils.IOUtils;
import org.jboss.gravia.utils.IllegalArgumentAssertion;
import org.jboss.gravia.utils.IllegalStateAssertion;
import org.jboss.gravia.utils.ManifestUtils;

public class EmbeddedUtils {
    private EmbeddedUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Runtime getEmbeddedRuntime() {
        Class<RuntimeLocator> clazz = RuntimeLocator.class;
        synchronized (RuntimeLocator.class) {
            Runtime runtime = RuntimeLocator.getRuntime();
            if (runtime == null) {
                RuntimeFactory factory = new RuntimeFactory(){

                    public Runtime createRuntime(PropertiesProvider propertiesProvider) {
                        return new EmbeddedRuntime(propertiesProvider, null){

                            public void init() {
                                URLStreamHandlerTracker tracker = new URLStreamHandlerTracker(this.getModuleContext());
                                URLStreamHandlerFactoryProxy.setDelegate((URLStreamHandlerTracker)tracker);
                                URLStreamHandlerFactoryProxy.register();
                                super.init();
                            }

                            protected ModuleEntriesProvider getDefaultEntriesProvider(Module module, Attachable context) {
                                return new ClassLoaderEntriesProvider(module);
                            }
                        };
                    }
                };
                runtime = RuntimeLocator.createRuntime((RuntimeFactory)factory, (PropertiesProvider)new DefaultPropertiesProvider(new HashMap(), true, "GRAVIA_"));
                runtime.init();
                ModuleContext syscontext = runtime.getModuleContext();
                RuntimeEnvironment environment = new RuntimeEnvironment(runtime);
                EmbeddedResourceInstaller resourceInstaller = new EmbeddedResourceInstaller(environment);
                syscontext.registerService(RuntimeEnvironment.class, (Object)environment, null);
                syscontext.registerService(ResourceInstaller.class, (Object)resourceInstaller, null);
            }
            // ** MonitorExit[var1] (shouldn't be in output)
            return runtime;
        }
    }

    public static Module installAndStartModule(ClassLoader classLoader, File location) throws ModuleException, IOException {
        return EmbeddedUtils.installAndStartModule(classLoader, location.toURI().toURL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Module installAndStartModule(ClassLoader classLoader, URL location) throws ModuleException, IOException {
        try (JarInputStream input = new JarInputStream(location.openStream());){
            Manifest manifest = input.getManifest();
            Dictionary headers = new ManifestHeadersProvider(manifest).getHeaders();
            Module module = EmbeddedUtils.installAndStartModule(classLoader, null, headers);
            return module;
        }
    }

    public static Module installAndStartModule(ClassLoader classLoader, String symbolicName, String version) throws ModuleException {
        ResourceIdentity.create((String)symbolicName, (String)version);
        Resource resource = new DefaultResourceBuilder().addIdentityCapability(symbolicName, version).getResource();
        return EmbeddedUtils.installAndStartModule(classLoader, resource);
    }

    public static Module installAndStartModule(ClassLoader classLoader, ResourceIdentity identity) throws ModuleException {
        Resource resource = new DefaultResourceBuilder().addIdentityCapability(identity).getResource();
        return EmbeddedUtils.installAndStartModule(classLoader, resource);
    }

    public static Module installAndStartModule(ClassLoader classLoader, Resource resource) throws ModuleException {
        return EmbeddedUtils.installAndStartModule(classLoader, resource, null);
    }

    public static Module installAndStartModule(ClassLoader classLoader, Resource resource, Dictionary<String, String> headers) throws ModuleException {
        Module module = EmbeddedUtils.getEmbeddedRuntime().installModule(classLoader, resource, headers);
        module.start();
        return module;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<ResourceIdentity> addRepositoryContent(URL resurl) throws IOException {
        IllegalArgumentAssertion.assertNotNull((Object)resurl, (String)"resurl");
        Repository repository = (Repository)ServiceLocator.getRequiredService(Repository.class);
        HashSet<ResourceIdentity> result = new HashSet<ResourceIdentity>();
        InputStream input = resurl.openStream();
        try {
            DefaultRepositoryXMLReader reader = new DefaultRepositoryXMLReader(input);
            Resource auxres = reader.nextResource();
            while (auxres != null) {
                ResourceIdentity identity = auxres.getIdentity();
                if (repository.getResource(identity) == null) {
                    repository.addResource(auxres);
                    result.add(identity);
                }
                auxres = reader.nextResource();
            }
        }
        finally {
            IOUtils.safeClose((Closeable)input);
        }
        return Collections.unmodifiableSet(result);
    }

    public static void removeRepositoryContent(Set<ResourceIdentity> identities) throws IOException {
        if (identities != null) {
            Repository repository = (Repository)ServiceLocator.getRequiredService(Repository.class);
            for (ResourceIdentity resid : identities) {
                repository.removeResource(resid);
            }
        }
    }

    public static void deleteDirectory(String directory) throws IOException {
        EmbeddedUtils.deleteDirectory(Paths.get(directory, new String[0]));
    }

    public static void deleteDirectory(Path directory) throws IOException {
        Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static class EmbeddedResourceInstaller
    extends AbstractResourceInstaller {
        private final RuntimeEnvironment environment;

        EmbeddedResourceInstaller(RuntimeEnvironment environment) {
            this.environment = environment;
        }

        public RuntimeEnvironment getEnvironment() {
            return this.environment;
        }

        public ResourceHandle installResourceProtected(ResourceInstaller.Context context, final Resource resource) throws Exception {
            ResourceContent content = this.getFirstRelevantResourceContent(resource);
            Manifest manifest = ManifestUtils.getManifest((InputStream)content.getContent());
            IllegalStateAssertion.assertNotNull((Object)manifest, (String)("Resource has no manifest: " + resource));
            Dictionary headers = ManifestUtils.getManifestHeaders((Manifest)manifest);
            Runtime runtime = this.environment.getRuntime();
            ClassLoader classLoader = EmbeddedRuntime.class.getClassLoader();
            final Module module = runtime.installModule(classLoader, resource, headers);
            module.start();
            return new ResourceHandle(){

                public Resource getResource() {
                    return resource;
                }

                public Module getModule() {
                    return module;
                }

                public void uninstall() {
                    module.uninstall();
                }
            };
        }
    }
}

