/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.arquillian.container.embedded;

import java.util.ServiceLoader;
import java.util.concurrent.TimeUnit;
import org.jboss.arquillian.core.spi.context.ObjectStore;
import org.jboss.arquillian.test.spi.event.suite.AfterSuite;
import org.jboss.arquillian.test.spi.event.suite.BeforeSuite;
import org.jboss.gravia.arquillian.container.SetupObserver;
import org.jboss.gravia.arquillian.container.SetupTask;
import org.jboss.gravia.arquillian.container.embedded.EmbeddedRuntimeSetup;
import org.jboss.gravia.arquillian.container.embedded.EmbeddedUtils;
import org.jboss.gravia.runtime.Runtime;
import org.jboss.gravia.runtime.RuntimeLocator;
import org.jboss.gravia.utils.IllegalStateAssertion;
import org.junit.Assert;

public class EmbeddedSetupObserver
extends SetupObserver<SetupTask> {
    public void handleBeforeSuite(BeforeSuite event) throws Throwable {
        super.handleBeforeSuite(event);
        Runtime runtime = RuntimeLocator.getRuntime();
        IllegalStateAssertion.assertNull((Object)runtime, (String)"Embedded Runtime already created without @RunWith(Arquillian.class)");
        runtime = EmbeddedUtils.getEmbeddedRuntime();
        ObjectStore suiteStore = this.getSuiteObjectStore();
        suiteStore.add(Runtime.class, (Object)runtime);
        for (EmbeddedRuntimeSetup setup : ServiceLoader.load(EmbeddedRuntimeSetup.class)) {
            setup.setupEmbeddedRuntime(suiteStore);
        }
    }

    public void handleAfterSuite(AfterSuite event) throws Throwable {
        Runtime runtime = (Runtime)this.getSuiteObjectStore().get(Runtime.class);
        if (runtime != null && !runtime.shutdownComplete()) {
            Assert.assertTrue((boolean)runtime.shutdown().awaitShutdown(20L, TimeUnit.SECONDS));
            RuntimeLocator.releaseRuntime();
        }
        super.handleAfterSuite(event);
    }
}

