/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.arquillian.container.managed;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import org.jboss.gravia.arquillian.container.SetupTask;
import org.jboss.gravia.repository.DefaultRepositoryXMLReader;
import org.jboss.gravia.repository.RepositoryMBean;
import org.jboss.gravia.resource.Resource;
import org.jboss.gravia.resource.ResourceIdentity;
import org.jboss.gravia.utils.IOUtils;
import org.jboss.gravia.utils.IllegalArgumentAssertion;
import org.jboss.gravia.utils.MBeanProxy;

public abstract class ManagedSetupTask
extends SetupTask {
    protected void beforeDeploy(ManagedContext context) throws Exception {
    }

    protected void beforeStop(ManagedContext context) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<ResourceIdentity> addRepositoryContent(ManagedContext context, URL resurl) throws IOException {
        IllegalArgumentAssertion.assertNotNull((Object)context, (String)"context");
        HashSet<ResourceIdentity> result = new HashSet<ResourceIdentity>();
        if (resurl != null) {
            InputStream input = resurl.openStream();
            RepositoryMBean repository = (RepositoryMBean)MBeanProxy.get((MBeanServerConnection)context.getMBeanServer(), (ObjectName)RepositoryMBean.OBJECT_NAME, RepositoryMBean.class);
            try {
                DefaultRepositoryXMLReader reader = new DefaultRepositoryXMLReader(input);
                Resource auxres = reader.nextResource();
                while (auxres != null) {
                    ResourceIdentity identity = auxres.getIdentity();
                    if (repository.getResource(identity.getCanonicalForm()) == null) {
                        repository.addResource((CompositeData)auxres.adapt(CompositeData.class));
                        result.add(identity);
                    }
                    auxres = reader.nextResource();
                }
            }
            finally {
                IOUtils.safeClose((Closeable)input);
            }
        }
        return Collections.unmodifiableSet(result);
    }

    protected void removeRepositoryContent(ManagedContext context, Set<ResourceIdentity> identities) throws IOException {
        IllegalArgumentAssertion.assertNotNull((Object)context, (String)"context");
        if (identities != null) {
            RepositoryMBean repository = (RepositoryMBean)MBeanProxy.get((MBeanServerConnection)context.getMBeanServer(), (ObjectName)RepositoryMBean.OBJECT_NAME, RepositoryMBean.class);
            for (ResourceIdentity resid : identities) {
                repository.removeResource(resid.getCanonicalForm());
            }
        }
    }

    public static interface ManagedContext
    extends SetupTask.SetupContext {
        public MBeanServerConnection getMBeanServer();

        public Map<String, String> getConfiguration();
    }
}

