/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.arquillian.container.managed;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.jboss.arquillian.container.spi.Container;
import org.jboss.arquillian.container.spi.event.container.AfterDeploy;
import org.jboss.arquillian.container.spi.event.container.AfterStart;
import org.jboss.arquillian.container.spi.event.container.AfterStop;
import org.jboss.arquillian.container.spi.event.container.BeforeDeploy;
import org.jboss.arquillian.container.spi.event.container.BeforeStop;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.spi.context.ObjectStore;
import org.jboss.arquillian.test.spi.context.ClassContext;
import org.jboss.arquillian.test.spi.context.SuiteContext;
import org.jboss.gravia.arquillian.container.SetupObserver;
import org.jboss.gravia.arquillian.container.managed.ManagedSetupTask;
import org.jboss.gravia.repository.RepositoryMBean;
import org.jboss.gravia.utils.MBeanProxy;

public class ManagedContainerSetupObserver
extends SetupObserver<ManagedSetupTask> {
    public static final String PROPERTY_JMX_SERVICE_URL = "jmxServiceURL";
    public static final String PROPERTY_JMX_USERNAME = "jmxUsername";
    public static final String PROPERTY_JMX_PASSWORD = "jmxPassword";
    @Inject
    private Instance<SuiteContext> suiteContextInstance;
    @Inject
    private Instance<ClassContext> classContextInstance;
    @Inject
    @ApplicationScoped
    private InstanceProducer<MBeanServerConnection> mbeanServerInstance;
    @Inject
    @ApplicationScoped
    private InstanceProducer<RepositoryMBean> repositoryInstance;

    protected ManagedSetupContext getSetupContext(ObjectStore suiteStore, ObjectStore classStore) {
        MBeanServerConnection server = (MBeanServerConnection)this.mbeanServerInstance.get();
        return new ManagedSetupContext(suiteStore, classStore, server, null);
    }

    public void handleAfterStart(@Observes AfterStart event, Container container) throws Throwable {
        MBeanServerConnection mbeanServer = this.getMBeanServerConnection(container);
        if (mbeanServer != null) {
            this.mbeanServerInstance.set((Object)mbeanServer);
            if (mbeanServer.isRegistered(RepositoryMBean.OBJECT_NAME)) {
                RepositoryMBean repository = (RepositoryMBean)MBeanProxy.get((MBeanServerConnection)mbeanServer, (ObjectName)RepositoryMBean.OBJECT_NAME, RepositoryMBean.class);
                this.repositoryInstance.set((Object)repository);
            }
        }
    }

    public void handleBeforeDeploy(@Observes BeforeDeploy event, Container container) throws Throwable {
        List setupTasks = this.getSetupTasks();
        if (!setupTasks.isEmpty()) {
            ClassContext classContext = (ClassContext)this.classContextInstance.get();
            ObjectStore suiteStore = ((SuiteContext)this.suiteContextInstance.get()).getObjectStore();
            ObjectStore classStore = classContext.getObjectStore();
            MBeanServerConnection server = (MBeanServerConnection)this.mbeanServerInstance.get();
            Map props = container.getContainerConfiguration().getContainerProperties();
            ManagedSetupContext context = new ManagedSetupContext(suiteStore, classStore, server, props);
            for (ManagedSetupTask task : setupTasks) {
                task.beforeDeploy(context);
            }
        }
    }

    public void handleAfterDeploy(@Observes AfterDeploy event, Container container) throws Throwable {
    }

    public void handleBeforeStop(@Observes BeforeStop event, Container container) throws Throwable {
        List setupTasks = this.getSetupTasks();
        if (!setupTasks.isEmpty()) {
            ObjectStore suiteStore = ((SuiteContext)this.suiteContextInstance.get()).getObjectStore();
            MBeanServerConnection server = (MBeanServerConnection)this.mbeanServerInstance.get();
            Map props = container.getContainerConfiguration().getContainerProperties();
            ManagedSetupContext context = new ManagedSetupContext(suiteStore, null, server, props);
            for (ManagedSetupTask task : setupTasks) {
                task.beforeStop(context);
            }
        }
    }

    public void handleAfterStop(@Observes AfterStop event, Container container) throws Throwable {
    }

    private MBeanServerConnection getMBeanServerConnection(Container container) throws IOException {
        Map props = container.getContainerConfiguration().getContainerProperties();
        String jmxServiceURL = (String)props.get(PROPERTY_JMX_SERVICE_URL);
        String jmxUsername = (String)props.get(PROPERTY_JMX_USERNAME);
        String jmxPassword = (String)props.get(PROPERTY_JMX_PASSWORD);
        MBeanServerConnection mbeanServer = null;
        try {
            JMXServiceURL serviceURL = new JMXServiceURL(jmxServiceURL);
            HashMap<String, String[]> env = new HashMap<String, String[]>();
            if (jmxUsername != null && jmxPassword != null) {
                String[] credentials = new String[]{jmxUsername, jmxPassword};
                env.put("jmx.remote.credentials", credentials);
            }
            JMXConnector connector = JMXConnectorFactory.connect(serviceURL, env);
            mbeanServer = connector.getMBeanServerConnection();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return mbeanServer;
    }

    private static final class ManagedSetupContext
    extends SetupObserver.AbstractSetupContext
    implements ManagedSetupTask.ManagedContext {
        private final MBeanServerConnection server;
        private final Map<String, String> configuration;

        ManagedSetupContext(ObjectStore suiteStore, ObjectStore classStore, MBeanServerConnection server, Map<String, String> configuration) {
            super(suiteStore, classStore);
            this.server = server;
            this.configuration = configuration;
        }

        @Override
        public MBeanServerConnection getMBeanServer() {
            return this.server;
        }

        @Override
        public Map<String, String> getConfiguration() {
            return Collections.unmodifiableMap(this.configuration);
        }
    }
}

