/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.container.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Properties;
import org.jboss.gravia.runtime.ModuleContext;
import org.jboss.gravia.runtime.RuntimeLocator;
import org.jboss.gravia.runtime.ServiceReference;
import org.jboss.gravia.runtime.spi.RuntimeLogger;
import org.jboss.gravia.utils.NotNullException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public final class ActivationSupport {
    private ActivationSupport() {
    }

    public static void initConfigurationAdmin(File configsDir) {
        NotNullException.assertValue((Object)configsDir, (String)"configsDir");
        ConfigurationAdmin configAdmin = ActivationSupport.getConfigurationAdmin();
        if (!configsDir.isDirectory() || configAdmin == null) {
            RuntimeLogger.LOGGER.info("No ConfigurationAdmin content");
            return;
        }
        RuntimeLogger.LOGGER.info("Loading ConfigurationAdmin content from: " + configsDir);
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".cfg");
            }
        };
        for (String name : configsDir.list(filter)) {
            RuntimeLogger.LOGGER.info("Loading configuration: " + name);
            String pid = name.substring(0, name.length() - 4);
            try {
                FileInputStream fis = new FileInputStream(new File(configsDir, name));
                Properties props = new Properties();
                props.load(fis);
                fis.close();
                if (props.isEmpty()) continue;
                Configuration config = configAdmin.getConfiguration(pid, null);
                config.update((Dictionary)props);
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    private static ConfigurationAdmin getConfigurationAdmin() {
        ModuleContext syscontext = RuntimeLocator.getRequiredRuntime().getModuleContext();
        ServiceReference sref = syscontext.getServiceReference(ConfigurationAdmin.class);
        return sref != null ? (ConfigurationAdmin)syscontext.getService(sref) : null;
    }
}

