/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.resource.spi;

import java.util.HashMap;
import java.util.Map;
import org.jboss.gravia.resource.Attachable;
import org.jboss.gravia.resource.AttachmentKey;
import org.jboss.gravia.utils.NotNullException;

public class AttachableSupport
implements Attachable {
    private Map<AttachmentKey<?>, Object> attachments;

    @Override
    public synchronized <T> T putAttachment(AttachmentKey<T> key, T value) {
        NotNullException.assertValue(key, "key");
        NotNullException.assertValue(value, "value");
        if (this.attachments == null) {
            this.attachments = new HashMap();
        }
        return (T)this.attachments.put(key, value);
    }

    @Override
    public synchronized <T> T getAttachment(AttachmentKey<T> key) {
        NotNullException.assertValue(key, "key");
        return (T)(this.attachments != null ? this.attachments.get(key) : null);
    }

    @Override
    public synchronized <T> boolean hasAttachment(AttachmentKey<T> key) {
        NotNullException.assertValue(key, "key");
        return this.attachments != null ? this.attachments.containsKey(key) : false;
    }

    @Override
    public synchronized <T> T removeAttachment(AttachmentKey<T> key) {
        NotNullException.assertValue(key, "key");
        return (T)(this.attachments != null ? this.attachments.remove(key) : null);
    }
}

