/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.runtime.osgi.internal;

import java.io.File;
import java.util.Dictionary;
import org.jboss.gravia.resource.Resource;
import org.jboss.gravia.runtime.Module;
import org.jboss.gravia.runtime.ModuleContext;
import org.jboss.gravia.runtime.ModuleException;
import org.jboss.gravia.runtime.osgi.internal.ModuleContextAdaptor;
import org.jboss.gravia.runtime.osgi.internal.OSGiRuntime;
import org.jboss.gravia.runtime.spi.AbstractModule;
import org.jboss.gravia.runtime.spi.AbstractRuntime;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleReference;

final class ModuleAdaptor
extends AbstractModule {
    private final Bundle bundle;

    ModuleAdaptor(OSGiRuntime runtime, ClassLoader classLoader, Resource resource, Dictionary<String, String> headers) {
        super((AbstractRuntime)runtime, classLoader, resource, headers);
        this.bundle = classLoader instanceof BundleReference ? ((BundleReference)classLoader).getBundle() : runtime.getSystemContext().getBundle();
    }

    public <A> A adapt(Class<A> type) {
        Object result = super.adapt(type);
        if (result == null && type.isAssignableFrom(Bundle.class)) {
            result = this.bundle;
        }
        return (A)result;
    }

    public Module.State getState() {
        int bundleState = this.bundle.getState();
        switch (bundleState) {
            case 2: {
                return Module.State.INSTALLED;
            }
            case 4: {
                return Module.State.RESOLVED;
            }
            case 8: {
                return Module.State.STARTING;
            }
            case 32: {
                return Module.State.ACTIVE;
            }
            case 16: {
                return Module.State.STOPPING;
            }
            case 1: {
                return Module.State.UNINSTALLED;
            }
        }
        throw new IllegalArgumentException("Unsupported bundle state: " + bundleState);
    }

    protected Bundle getBundleAdaptor(Module module) {
        return this.bundle;
    }

    protected void setState(Module.State newState) {
    }

    public long getModuleId() {
        return this.bundle.getBundleId();
    }

    public ModuleContext getModuleContext() {
        BundleContext context = this.bundle.getBundleContext();
        return context != null ? new ModuleContextAdaptor((Module)this, context) : null;
    }

    public void start() throws ModuleException {
        try {
            this.bundle.start();
        }
        catch (BundleException ex) {
            throw ModuleException.launderThrowable((Throwable)ex);
        }
    }

    public void stop() throws ModuleException {
        try {
            this.bundle.stop();
        }
        catch (BundleException ex) {
            throw ModuleException.launderThrowable((Throwable)ex);
        }
    }

    public void uninstall() {
        try {
            this.bundle.uninstall();
            this.getRuntime().uninstallModule((Module)this);
        }
        catch (BundleException ex) {
            ModuleException.launderThrowable((Throwable)ex);
        }
    }

    public File getDataFile(String filename) {
        return this.bundle.getDataFile(filename);
    }

    protected OSGiRuntime getRuntime() {
        return (OSGiRuntime)super.getRuntime();
    }
}

