/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.runtime.osgi.internal;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import org.jboss.gravia.resource.Attachable;
import org.jboss.gravia.resource.DefaultResourceBuilder;
import org.jboss.gravia.resource.DictionaryResourceBuilder;
import org.jboss.gravia.resource.Resource;
import org.jboss.gravia.runtime.Module;
import org.jboss.gravia.runtime.ModuleException;
import org.jboss.gravia.runtime.osgi.internal.ModuleAdaptor;
import org.jboss.gravia.runtime.spi.AbstractModule;
import org.jboss.gravia.runtime.spi.AbstractRuntime;
import org.jboss.gravia.runtime.spi.ModuleEntriesProvider;
import org.jboss.gravia.runtime.spi.PropertiesProvider;
import org.jboss.gravia.runtime.spi.RuntimeLogger;
import org.jboss.gravia.utils.NotNullException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.util.tracker.BundleTracker;

public final class OSGiRuntime
extends AbstractRuntime {
    private final BundleContext syscontext;
    private final BundleTracker<Bundle> tracker;

    public OSGiRuntime(BundleContext syscontext, PropertiesProvider propertiesProvider) {
        super(propertiesProvider);
        NotNullException.assertValue((Object)syscontext, (String)"syscontext");
        this.syscontext = syscontext;
        if (syscontext.getBundle().getBundleId() != 0L) {
            throw new IllegalArgumentException("Not the system bundle: " + syscontext.getBundle());
        }
        Resource resource = new DefaultResourceBuilder().addIdentityCapability(this.getSystemIdentity()).getResource();
        try {
            BundleWiring wiring = (BundleWiring)syscontext.getBundle().adapt(BundleWiring.class);
            this.installModule(wiring.getClassLoader(), resource, null, null);
        }
        catch (ModuleException ex) {
            throw new IllegalStateException("Cannot install system module", ex);
        }
        this.tracker = new BundleTracker<Bundle>(syscontext, 60, null){

            public Bundle addingBundle(Bundle bundle, BundleEvent event) {
                BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
                ClassLoader classLoader = wiring != null ? wiring.getClassLoader() : null;
                DictionaryResourceBuilder resBuilder = new DictionaryResourceBuilder().load(bundle.getHeaders());
                if (classLoader != null && resBuilder.isValid()) {
                    try {
                        OSGiRuntime.this.installModule(classLoader, bundle.getHeaders());
                    }
                    catch (ModuleException ex) {
                        RuntimeLogger.LOGGER.error("Cannot install module from: " + bundle, (Throwable)ex);
                    }
                }
                return bundle;
            }

            public void remove(Bundle bundle) {
                Module module = OSGiRuntime.this.getModule(bundle.getBundleId());
                if (module != null) {
                    module.uninstall();
                }
                super.remove(bundle);
            }
        };
    }

    public void init() {
        this.tracker.open();
    }

    BundleContext getSystemContext() {
        return this.syscontext;
    }

    protected AbstractModule createModule(ClassLoader classLoader, Resource resource, Dictionary<String, String> headers, Attachable context) {
        return new ModuleAdaptor(this, classLoader, resource, headers);
    }

    protected ModuleEntriesProvider getDefaultEntriesProvider(Module module, Attachable context) {
        return new OSGiModuleEntriesProvider(module);
    }

    protected void uninstallModule(Module module) {
        super.uninstallModule(module);
    }

    private class OSGiModuleEntriesProvider
    implements ModuleEntriesProvider {
        private final Module module;

        OSGiModuleEntriesProvider(Module module) {
            this.module = module;
        }

        public List<String> getEntryPaths(String path) {
            Bundle bundle = OSGiRuntime.this.syscontext.getBundle(this.module.getModuleId());
            Enumeration paths = bundle.getEntryPaths(path);
            ArrayList<String> result = new ArrayList<String>();
            if (paths != null) {
                while (paths.hasMoreElements()) {
                    String element = (String)paths.nextElement();
                    result.add(element);
                }
            }
            return Collections.unmodifiableList(result);
        }

        public URL getEntry(String path) {
            Bundle bundle = OSGiRuntime.this.syscontext.getBundle(this.module.getModuleId());
            return bundle.getEntry(path);
        }

        public List<URL> findEntries(String path, String filePattern, boolean recurse) {
            Bundle bundle = OSGiRuntime.this.syscontext.getBundle(this.module.getModuleId());
            Enumeration paths = bundle.findEntries(path, filePattern, recurse);
            ArrayList<URL> result = new ArrayList<URL>();
            if (paths != null) {
                while (paths.hasMoreElements()) {
                    URL element = (URL)paths.nextElement();
                    result.add(element);
                }
            }
            return Collections.unmodifiableList(result);
        }
    }
}

