/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.jetty.internal;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.servlet.ServletContext;
import org.apache.felix.http.base.internal.DispatcherServlet;
import org.apache.felix.http.base.internal.EventDispatcher;
import org.apache.felix.http.base.internal.HttpServiceController;
import org.apache.felix.http.base.internal.logger.SystemLogger;
import org.apache.felix.http.jetty.internal.JettyConfig;
import org.apache.felix.http.jetty.internal.JettyManagedService;
import org.apache.felix.http.jetty.internal.MBeanServerTracker;
import org.apache.felix.http.jetty.internal.WebAppBundleContext;
import org.apache.felix.http.jetty.internal.WebEvent;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.server.bio.SocketConnector;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.server.ssl.SslConnector;
import org.eclipse.jetty.server.ssl.SslSelectChannelConnector;
import org.eclipse.jetty.server.ssl.SslSocketConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JettyService
extends AbstractLifeCycle.AbstractLifeCycleListener
implements BundleTrackerCustomizer,
ServiceTrackerCustomizer {
    private static final String PID = "org.apache.felix.http";
    private static final String REG_PROPERTY_ENDPOINTS = "osgi.http.service.endpoints";
    private static final String HEADER_WEB_CONTEXT_PATH = "Web-ContextPath";
    private static final String HEADER_ACTIVATION_POLICY = "Bundle-ActivationPolicy";
    private static final String WEB_SYMBOLIC_NAME = "osgi.web.symbolicname";
    private static final String WEB_VERSION = "osgi.web.version";
    private static final String WEB_CONTEXT_PATH = "osgi.web.contextpath";
    private static final String OSGI_BUNDLE_CONTEXT = "osgi-bundlecontext";
    private final JettyConfig config;
    private final BundleContext context;
    private ServiceRegistration configServiceReg;
    private ExecutorService executor;
    private Server server;
    private ContextHandlerCollection parent;
    private DispatcherServlet dispatcher;
    private EventDispatcher eventDispatcher;
    private final HttpServiceController controller;
    private MBeanServerTracker mbeanServerTracker;
    private BundleTracker bundleTracker;
    private ServiceTracker serviceTracker;
    private EventAdmin eventAdmin;
    private Map<String, Deployment> deployments = new LinkedHashMap<String, Deployment>();

    public JettyService(BundleContext context, DispatcherServlet dispatcher, EventDispatcher eventDispatcher, HttpServiceController controller) {
        this.context = context;
        this.config = new JettyConfig(this.context);
        this.dispatcher = dispatcher;
        this.eventDispatcher = eventDispatcher;
        this.controller = controller;
    }

    public void start() throws Exception {
        Properties props = new Properties();
        props.put("service.pid", PID);
        this.configServiceReg = this.context.registerService("org.osgi.service.cm.ManagedService", (Object)new JettyManagedService(this), (Dictionary)props);
        this.executor = Executors.newSingleThreadExecutor(new ThreadFactory(){

            public Thread newThread(Runnable runnable) {
                Thread t = new Thread(runnable);
                t.setName("Jetty HTTP Service");
                return t;
            }
        });
        this.executor.submit(new JettyOperation(){

            protected void doExecute() throws Exception {
                JettyService.this.startJetty();
            }
        });
        this.serviceTracker = new ServiceTracker(this.context, EventAdmin.class.getName(), (ServiceTrackerCustomizer)this);
        this.serviceTracker.open();
        this.bundleTracker = new BundleTracker(this.context, 40, (BundleTrackerCustomizer)this);
        this.bundleTracker.open();
    }

    public void stop() throws Exception {
        if (this.executor != null && !this.executor.isShutdown()) {
            this.executor.submit(new JettyOperation(){

                protected void doExecute() throws Exception {
                    JettyService.this.stopJetty();
                }
            });
            this.executor.shutdown();
        }
        if (this.configServiceReg != null) {
            this.configServiceReg.unregister();
        }
        if (this.bundleTracker != null) {
            this.bundleTracker.close();
        }
        if (this.serviceTracker != null) {
            this.serviceTracker.close();
        }
    }

    private void publishServiceProperties() {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        this.config.setServiceProperties(props);
        this.addEndpointProperties(props, null);
        this.controller.setProperties(props);
    }

    public void updated(Dictionary props) {
        this.config.update(props);
        if (this.executor != null && !this.executor.isShutdown()) {
            this.executor.submit(new JettyOperation(){

                protected void doExecute() throws Exception {
                    JettyService.this.stopJetty();
                    JettyService.this.startJetty();
                }
            });
        }
    }

    private void startJetty() {
        try {
            this.initializeJetty();
        }
        catch (Exception e) {
            SystemLogger.error("Exception while initializing Jetty.", e);
        }
    }

    private void stopJetty() {
        if (this.server != null) {
            try {
                this.server.stop();
                this.server = null;
            }
            catch (Exception e) {
                SystemLogger.error("Exception while stopping Jetty.", e);
            }
            if (this.mbeanServerTracker != null) {
                this.mbeanServerTracker.close();
                this.mbeanServerTracker = null;
            }
        }
    }

    private void initializeJetty() throws Exception {
        if (this.config.isUseHttp() || this.config.isUseHttps()) {
            StringBuffer message = new StringBuffer("Started jetty ").append(Server.getVersion()).append(" at port(s)");
            HashLoginService realm = new HashLoginService("OSGi HTTP Service Realm");
            this.server = new Server();
            this.server.addLifeCycleListener(this);
            this.server.setSendDateHeader(true);
            this.server.addBean(realm);
            if (this.config.isUseHttp()) {
                this.initializeHttp();
                message.append(" HTTP:").append(this.config.getHttpPort());
            }
            if (this.config.isUseHttps()) {
                this.initializeHttps();
                message.append(" HTTPS:").append(this.config.getHttpsPort());
            }
            this.parent = new ContextHandlerCollection();
            ServletContextHandler context = new ServletContextHandler(this.parent, this.config.getContextPath(), 1);
            message.append(" on context path ").append(this.config.getContextPath());
            this.configureSessionManager(context);
            context.addEventListener(this.eventDispatcher);
            context.getSessionHandler().addEventListener(this.eventDispatcher);
            context.addServlet(new ServletHolder(this.dispatcher), "/*");
            if (this.config.isRegisterMBeans()) {
                this.mbeanServerTracker = new MBeanServerTracker(this.context, this.server);
                this.mbeanServerTracker.open();
                context.addBean(new StatisticsHandler());
            }
            this.server.setHandler(this.parent);
            this.server.start();
            SystemLogger.info(message.toString());
        } else {
            SystemLogger.info("Jetty not started (HTTP and HTTPS disabled)");
        }
        this.publishServiceProperties();
    }

    private void initializeHttp() throws Exception {
        AbstractConnector connector = this.config.isUseHttpNio() ? new SelectChannelConnector() : new SocketConnector();
        connector.setPort(this.config.getHttpPort());
        this.configureConnector(connector);
        this.server.addConnector(connector);
    }

    private void initializeHttps() throws Exception {
        AbstractConnector connector;
        if (this.config.isUseHttpsNio()) {
            SslSelectChannelConnector sslConnector = new SslSelectChannelConnector();
            if (this.config.getKeystore() != null) {
                sslConnector.setKeystore(this.config.getKeystore());
            }
            if (this.config.getPassword() != null) {
                System.setProperty("org.eclipse.jetty.ssl.password", this.config.getPassword());
                sslConnector.setPassword(this.config.getPassword());
            }
            if (this.config.getKeyPassword() != null) {
                System.setProperty("org.eclipse.jetty.ssl.keypassword", this.config.getKeyPassword());
                sslConnector.setKeyPassword(this.config.getKeyPassword());
            }
            if (this.config.getTruststore() != null) {
                sslConnector.setTruststore(this.config.getTruststore());
            }
            if (this.config.getTrustPassword() != null) {
                sslConnector.setTrustPassword(this.config.getTrustPassword());
            }
            if ("wants".equals(this.config.getClientcert())) {
                sslConnector.setWantClientAuth(true);
            } else if ("needs".equals(this.config.getClientcert())) {
                sslConnector.setNeedClientAuth(true);
            }
            connector = sslConnector;
        } else {
            SslSocketConnector sslConnector = new SslSocketConnector();
            if (this.config.getKeystore() != null) {
                sslConnector.setKeystore(this.config.getKeystore());
            }
            if (this.config.getPassword() != null) {
                System.setProperty("org.eclipse.jetty.ssl.password", this.config.getPassword());
                sslConnector.setPassword(this.config.getPassword());
            }
            if (this.config.getKeyPassword() != null) {
                System.setProperty("org.eclipse.jetty.ssl.keypassword", this.config.getKeyPassword());
                sslConnector.setKeyPassword(this.config.getKeyPassword());
            }
            if (this.config.getTruststore() != null) {
                sslConnector.setTruststore(this.config.getTruststore());
            }
            if (this.config.getTrustPassword() != null) {
                sslConnector.setTrustPassword(this.config.getTrustPassword());
            }
            if ("wants".equals(this.config.getClientcert())) {
                sslConnector.setWantClientAuth(true);
            } else if ("needs".equals(this.config.getClientcert())) {
                sslConnector.setNeedClientAuth(true);
            }
            connector = sslConnector;
        }
        connector.setPort(this.config.getHttpsPort());
        this.configureConnector(connector);
        this.server.addConnector(connector);
    }

    private void configureConnector(Connector connector) {
        connector.setMaxIdleTime(this.config.getHttpTimeout());
        connector.setRequestBufferSize(this.config.getRequestBufferSize());
        connector.setResponseBufferSize(this.config.getResponseBufferSize());
        connector.setHost(this.config.getHost());
        connector.setStatsOn(this.config.isRegisterMBeans());
    }

    private void configureSessionManager(ServletContextHandler context) {
        SessionManager manager = context.getSessionHandler().getSessionManager();
        manager.setMaxInactiveInterval(this.config.getSessionTimeout() * 60);
        manager.setSessionCookie(this.config.getProperty("org.eclipse.jetty.servlet.SessionCookie", "JSESSIONID"));
        manager.setSessionIdPathParameterName(this.config.getProperty("org.eclipse.jetty.servlet.SessionIdPathParameterName", "jsessionid"));
        manager.setSessionDomain(this.config.getProperty("org.eclipse.jetty.servlet.SessionDomain", SessionManager.__DefaultSessionDomain));
        manager.setSessionPath(this.config.getProperty("org.eclipse.jetty.servlet.SessionPath", context.getContextPath()));
        manager.setMaxCookieAge(this.config.getIntProperty("org.eclipse.jetty.servlet.MaxAge", -1));
    }

    private String getEndpoint(Connector listener, InetAddress ia) {
        if (ia.isLoopbackAddress()) {
            return null;
        }
        String address = ia.getHostAddress().trim().toLowerCase();
        if (ia instanceof Inet6Address) {
            if (address.startsWith("fe80:0:0:0:")) {
                return null;
            }
            address = "[" + address + "]";
        } else if (!(ia instanceof Inet4Address)) {
            return null;
        }
        return this.getEndpoint(listener, address);
    }

    private String getEndpoint(Connector listener, String hostname) {
        StringBuilder sb = new StringBuilder();
        sb.append("http");
        int defaultPort = 80;
        if (listener instanceof SslConnector) {
            sb.append('s');
            defaultPort = 443;
        }
        sb.append("://");
        sb.append(hostname);
        if (listener.getPort() != defaultPort) {
            sb.append(':');
            sb.append(String.valueOf(listener.getPort()));
        }
        sb.append(this.config.getContextPath());
        return sb.toString();
    }

    private List<String> getEndpoints(Connector connector, List<NetworkInterface> interfaces) {
        ArrayList<String> endpoints = new ArrayList<String>();
        for (NetworkInterface ni : interfaces) {
            Enumeration<InetAddress> ias = ni.getInetAddresses();
            while (ias.hasMoreElements()) {
                InetAddress ia = ias.nextElement();
                String endpoint = this.getEndpoint(connector, ia);
                if (endpoint == null) continue;
                endpoints.add(endpoint);
            }
        }
        return endpoints;
    }

    private void addEndpointProperties(Hashtable<String, Object> props, Object container) {
        ArrayList<String> endpoints = new ArrayList<String>();
        Connector[] connectors = this.server.getConnectors();
        if (connectors != null) {
            for (int i = 0; i < connectors.length; ++i) {
                Connector connector = connectors[i];
                if (connector.getHost() == null) {
                    try {
                        ArrayList<NetworkInterface> interfaces = new ArrayList<NetworkInterface>();
                        ArrayList<NetworkInterface> loopBackInterfaces = new ArrayList<NetworkInterface>();
                        Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
                        while (nis.hasMoreElements()) {
                            NetworkInterface ni = nis.nextElement();
                            if (ni.isLoopback()) {
                                loopBackInterfaces.add(ni);
                                continue;
                            }
                            interfaces.add(ni);
                        }
                        if (!interfaces.isEmpty()) {
                            endpoints.addAll(this.getEndpoints(connector, interfaces));
                            continue;
                        }
                        endpoints.addAll(this.getEndpoints(connector, loopBackInterfaces));
                    }
                    catch (SocketException se) {}
                    continue;
                }
                String endpoint = this.getEndpoint(connector, connector.getHost());
                if (endpoint == null) continue;
                endpoints.add(endpoint);
            }
        }
        props.put(REG_PROPERTY_ENDPOINTS, endpoints.toArray(new String[endpoints.size()]));
    }

    private Deployment startWebAppBundle(Bundle bundle, String contextPath) {
        this.postEvent(WebEvent.DEPLOYING(bundle, this.context.getBundle()));
        Deployment deployment = this.deployments.get(contextPath);
        if (deployment != null) {
            SystemLogger.warning(String.format("Web application bundle %s has context path %s which is already registered", bundle.getSymbolicName(), contextPath), null);
            this.postEvent(WebEvent.FAILED(bundle, this.context.getBundle(), null, contextPath, deployment.getBundle().getBundleId()));
            return null;
        }
        if (contextPath.equals("/")) {
            SystemLogger.warning(String.format("Web application bundle %s has context path %s which is reserved", bundle.getSymbolicName(), contextPath), null);
            this.postEvent(WebEvent.FAILED(bundle, this.context.getBundle(), null, contextPath, this.context.getBundle().getBundleId()));
            return null;
        }
        for (String path : this.config.getPathExclusions()) {
            if (!contextPath.startsWith(path)) continue;
            SystemLogger.warning(String.format("Web application bundle %s has context path %s which clashes with excluded path prefix %s", bundle.getSymbolicName(), contextPath, path), null);
            this.postEvent(WebEvent.FAILED(bundle, this.context.getBundle(), null, path, null));
            return null;
        }
        deployment = new Deployment(contextPath, bundle);
        this.deployments.put(contextPath, deployment);
        WebAppBundleContext context = new WebAppBundleContext(contextPath, bundle, this.getClass().getClassLoader());
        this.deploy(deployment, context);
        return deployment;
    }

    public void deploy(final Deployment deployment, final WebAppBundleContext context) {
        if (this.executor != null && !this.executor.isShutdown()) {
            this.executor.submit(new JettyOperation(){

                protected void doExecute() {
                    Bundle webAppBundle = deployment.getBundle();
                    Bundle extenderBundle = JettyService.this.context.getBundle();
                    try {
                        JettyService.this.parent.addHandler(context);
                        context.start();
                        Hashtable<String, String> props = new Hashtable<String, String>();
                        ((Dictionary)props).put(JettyService.WEB_SYMBOLIC_NAME, webAppBundle.getSymbolicName());
                        ((Dictionary)props).put(JettyService.WEB_VERSION, (String)webAppBundle.getVersion());
                        ((Dictionary)props).put(JettyService.WEB_CONTEXT_PATH, deployment.getContextPath());
                        deployment.setRegistration(webAppBundle.getBundleContext().registerService(ServletContext.class.getName(), (Object)context.getServletContext(), props));
                        context.getServletContext().setAttribute(JettyService.OSGI_BUNDLE_CONTEXT, webAppBundle.getBundleContext());
                        JettyService.this.postEvent(WebEvent.DEPLOYED(webAppBundle, extenderBundle));
                    }
                    catch (Exception e) {
                        SystemLogger.error(String.format("Deploying web application bundle %s failed.", webAppBundle.getSymbolicName()), e);
                        JettyService.this.postEvent(WebEvent.FAILED(webAppBundle, extenderBundle, e, null, null));
                        deployment.setContext(null);
                    }
                }
            });
            deployment.setContext(context);
        }
    }

    public void undeploy(final Deployment deployment, final WebAppBundleContext context) {
        if (this.executor != null && !this.executor.isShutdown()) {
            this.executor.submit(new JettyOperation(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void doExecute() {
                    Bundle webAppBundle = deployment.getBundle();
                    Bundle extenderBundle = JettyService.this.context.getBundle();
                    try {
                        JettyService.this.postEvent(WebEvent.UNDEPLOYING(webAppBundle, extenderBundle));
                        context.getServletContext().removeAttribute(JettyService.OSGI_BUNDLE_CONTEXT);
                        ServiceRegistration registration = deployment.getRegistration();
                        if (registration != null) {
                            registration.unregister();
                        }
                        deployment.setRegistration(null);
                        context.stop();
                    }
                    catch (Exception e) {
                        SystemLogger.error(String.format("Undeploying web application bundle %s failed.", webAppBundle.getSymbolicName()), e);
                    }
                    finally {
                        JettyService.this.postEvent(WebEvent.UNDEPLOYED(webAppBundle, extenderBundle));
                    }
                }
            });
        }
        deployment.setContext(null);
    }

    public Object addingBundle(Bundle bundle, BundleEvent event) {
        return this.detectWebAppBundle(bundle);
    }

    public void modifiedBundle(Bundle bundle, BundleEvent event, Object object) {
        this.detectWebAppBundle(bundle);
    }

    private Object detectWebAppBundle(Bundle bundle) {
        String contextPath;
        if ((bundle.getState() == 32 || bundle.getState() == 8 && "Lazy".equals(bundle.getHeaders().get(HEADER_ACTIVATION_POLICY))) && (contextPath = (String)bundle.getHeaders().get(HEADER_WEB_CONTEXT_PATH)) != null) {
            return this.startWebAppBundle(bundle, contextPath);
        }
        return null;
    }

    public void removedBundle(Bundle bundle, BundleEvent event, Object object) {
        String contextPath = (String)bundle.getHeaders().get(HEADER_WEB_CONTEXT_PATH);
        if (contextPath == null) {
            return;
        }
        Deployment deployment = this.deployments.remove(contextPath);
        if (deployment != null && deployment.getContext() != null) {
            deployment.setRegistration(null);
            this.undeploy(deployment, deployment.getContext());
        }
    }

    public Object addingService(ServiceReference reference) {
        Object service = this.context.getService(reference);
        this.modifiedService(reference, service);
        return service;
    }

    public void modifiedService(ServiceReference reference, Object service) {
        this.eventAdmin = (EventAdmin)service;
    }

    public void removedService(ServiceReference reference, Object service) {
        this.context.ungetService(reference);
        this.eventAdmin = null;
    }

    private void postEvent(Event event) {
        if (this.eventAdmin != null) {
            this.eventAdmin.postEvent(event);
        }
    }

    @Override
    public void lifeCycleStarted(LifeCycle event) {
        for (Deployment deployment : this.deployments.values()) {
            if (deployment.getContext() != null) continue;
            this.postEvent(WebEvent.DEPLOYING(deployment.getBundle(), this.context.getBundle()));
            WebAppBundleContext context = new WebAppBundleContext(deployment.getContextPath(), deployment.getBundle(), this.getClass().getClassLoader());
            this.deploy(deployment, context);
        }
    }

    @Override
    public void lifeCycleStopping(LifeCycle event) {
        for (Deployment deployment : this.deployments.values()) {
            if (deployment.getContext() == null) continue;
            this.undeploy(deployment, deployment.getContext());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class JettyOperation
    implements Callable<Void> {
        JettyOperation() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                this.doExecute();
                Void void_ = null;
                return void_;
            }
            finally {
                Thread.currentThread().setContextClassLoader(cl);
            }
        }

        protected abstract void doExecute() throws Exception;
    }

    static class Deployment {
        private String contextPath;
        private Bundle bundle;
        private WebAppBundleContext context;
        private ServiceRegistration registration;

        public Deployment(String contextPath, Bundle bundle) {
            this.contextPath = contextPath;
            this.bundle = bundle;
        }

        public Bundle getBundle() {
            return this.bundle;
        }

        public String getContextPath() {
            return this.contextPath;
        }

        public WebAppBundleContext getContext() {
            return this.context;
        }

        public void setContext(WebAppBundleContext context) {
            this.context = context;
        }

        public ServiceRegistration getRegistration() {
            return this.registration;
        }

        public void setRegistration(ServiceRegistration registration) {
            this.registration = registration;
        }
    }
}

