/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.utils;

import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.jboss.gravia.utils.NotNullException;

public class CaseInsensitiveDictionary<V>
extends Hashtable<String, V> {
    private static final long serialVersionUID = 5802491129524016545L;
    private Dictionary<String, V> delegate;
    private Set<String> originalKeys;

    public CaseInsensitiveDictionary(Dictionary<String, V> delegate) {
        NotNullException.assertValue(delegate, "delegate");
        this.delegate = new Hashtable<String, V>(delegate.size());
        this.originalKeys = Collections.synchronizedSet(new HashSet());
        Enumeration<String> e = delegate.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            if (this.get(key) != null) {
                throw new IllegalArgumentException("Duplicates for key [" + key + "] in: " + delegate);
            }
            this.delegate.put(key.toLowerCase(Locale.ENGLISH), delegate.get(key));
            this.originalKeys.add(key);
        }
    }

    @Override
    public Enumeration<V> elements() {
        return this.delegate.elements();
    }

    @Override
    public synchronized boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof Dictionary)) {
            return false;
        }
        Dictionary other = (Dictionary)obj;
        if (this.size() != other.size()) {
            return false;
        }
        if (this.isEmpty()) {
            return true;
        }
        for (String key : this.originalKeys) {
            if (!this.get(key).equals(other.get(key))) continue;
            return false;
        }
        return true;
    }

    @Override
    public V get(Object key) {
        if (key instanceof String) {
            key = ((String)key).toLowerCase(Locale.ENGLISH);
        }
        return this.delegate.get(key);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public Enumeration<String> keys() {
        return new Vector<String>(this.originalKeys).elements();
    }

    @Override
    public V put(String key, V value) {
        throw new UnsupportedOperationException("immutable");
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException("immutable");
    }

    @Override
    public Set<String> keySet() {
        return this.originalKeys;
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        HashSet<Map.Entry<String, V>> entrySet = new HashSet<Map.Entry<String, V>>();
        for (final String key : this.originalKeys) {
            final V value = this.get(key);
            Map.Entry entry = new Map.Entry<String, V>(){

                @Override
                public String getKey() {
                    return key;
                }

                @Override
                public V getValue() {
                    return value;
                }

                @Override
                public V setValue(Object value2) {
                    throw new UnsupportedOperationException("immutable");
                }
            };
            entrySet.add(entry);
        }
        return entrySet;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }
}

