/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.repository;

import java.io.IOException;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.StandardMBean;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import org.jboss.gravia.repository.Repository;
import org.jboss.gravia.repository.RepositoryMBean;
import org.jboss.gravia.repository.spi.AbstractRepository;
import org.jboss.gravia.resource.CompositeDataResourceBuilder;
import org.jboss.gravia.resource.Resource;
import org.jboss.gravia.resource.ResourceIdentity;
import org.jboss.gravia.runtime.ModuleContext;
import org.jboss.gravia.runtime.ServiceReference;
import org.jboss.gravia.runtime.ServiceRegistration;
import org.jboss.gravia.utils.NotNullException;

public class RepositoryRuntimeRegistration {
    private RepositoryRuntimeRegistration() {
    }

    public static Registration registerRepository(ModuleContext context, Repository repository) {
        NotNullException.assertValue((Object)context, (String)"context");
        NotNullException.assertValue((Object)repository, (String)"repository");
        final ServiceRegistration sreg = context.registerService(Repository.class, (Object)repository, null);
        ServiceReference sref = context.getServiceReference(MBeanServer.class);
        final MBeanServer mbeanServer = (MBeanServer)context.getService(sref);
        try {
            RepositoryWrapper delegate = new RepositoryWrapper(repository);
            StandardMBean mbean = new StandardMBean(delegate, RepositoryMBean.class);
            mbeanServer.registerMBean(mbean, RepositoryMBean.OBJECT_NAME);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Cannot register repository MBean", ex);
        }
        return new Registration(){

            @Override
            public void unregister() {
                try {
                    mbeanServer.unregisterMBean(RepositoryMBean.OBJECT_NAME);
                }
                catch (Exception ex) {
                    AbstractRepository.LOGGER.error("Cannot unregister repository", (Throwable)ex);
                }
                sreg.unregister();
            }
        };
    }

    static class RepositoryWrapper
    implements RepositoryMBean {
        private final Repository repository;

        RepositoryWrapper(Repository repository) {
            this.repository = repository;
        }

        @Override
        public String getName() {
            return this.repository.getName();
        }

        @Override
        public TabularData findProviders(String namespace, String nsvalue, Map<String, Object> attributes, Map<String, String> directives) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CompositeData addResource(CompositeData resData) throws IOException {
            Resource resource = new CompositeDataResourceBuilder(resData).getResource();
            return (CompositeData)this.repository.addResource(resource).adapt(CompositeData.class);
        }

        @Override
        public CompositeData removeResource(String identity) {
            ResourceIdentity resid = ResourceIdentity.fromString((String)identity);
            Resource resource = this.repository.removeResource(resid);
            return resource != null ? (CompositeData)resource.adapt(CompositeData.class) : null;
        }

        @Override
        public CompositeData getResource(String identity) {
            ResourceIdentity resid = ResourceIdentity.fromString((String)identity);
            Resource resource = this.repository.getResource(resid);
            return resource != null ? (CompositeData)resource.adapt(CompositeData.class) : null;
        }
    }

    public static interface Registration {
        public void unregister();
    }
}

