/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.handler;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Properties;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.http.base.internal.handler.FilterHandler;
import org.apache.felix.http.base.internal.handler.HandlerRegistry;
import org.apache.felix.http.base.internal.handler.ServletHandler;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpServicePlugin
extends HttpServlet {
    private final HandlerRegistry registry;
    private final BundleContext context;
    private ServiceRegistration serviceReg;

    public HttpServicePlugin(BundleContext context, HandlerRegistry registry) {
        this.registry = registry;
        this.context = context;
    }

    public void register() {
        Properties props = new Properties();
        props.put("service.vendor", "Apache Software Foundation");
        props.put("service.description", "HTTP Service Web Console Plugin");
        props.put("felix.webconsole.label", "httpservice");
        props.put("felix.webconsole.title", "HTTP Service");
        props.put("felix.webconsole.configprinter.modes", "always");
        this.serviceReg = this.context.registerService(Servlet.class.getName(), (Object)this, (Dictionary)props);
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.getHtml(resp);
    }

    private void getHtml(HttpServletResponse resp) throws IOException {
        PrintWriter pw = resp.getWriter();
        this.printServletDetails(pw);
        this.printFilterDetails(pw);
    }

    private void printFilterDetails(PrintWriter pw) {
        pw.println("<p class=\"statline ui-state-highlight\">${Registered Filter Services}</p>");
        pw.println("<table class=\"nicetable\">");
        pw.println("<thead><tr>");
        pw.println("<th class=\"header\">${Pattern}</th>");
        pw.println("<th class=\"header\">${Filter(Ranking)}</th>");
        pw.println("<th class=\"header\">${Bundle}</th>");
        pw.println("</tr></thead>");
        Object[] filters = this.registry.getFilters();
        Arrays.sort(filters);
        String rowClass = "odd";
        for (Object filter : filters) {
            pw.println("<tr class=\"" + rowClass + " ui-state-default\">");
            pw.println("<td>" + ((FilterHandler)filter).getPattern() + "</td>");
            pw.println("<td>" + ((FilterHandler)filter).getFilter().getClass().getName() + "(" + ((FilterHandler)filter).getRanking() + ")" + "</td>");
            this.printBundleDetails(pw, ((FilterHandler)filter).getFilter().getClass());
            rowClass = rowClass.equals("odd") ? "even" : "odd";
        }
        pw.println("</table>");
    }

    private void printServletDetails(PrintWriter pw) {
        pw.println("<p class=\"statline ui-state-highlight\">${Registered Servlet Services}</p>");
        pw.println("<table class=\"nicetable\">");
        pw.println("<thead><tr>");
        pw.println("<th class=\"header\">${Alias}</th>");
        pw.println("<th class=\"header\">${Servlet}</th>");
        pw.println("<th class=\"header\">${Bundle}</th>");
        pw.println("</tr></thead>");
        ServletHandler[] servlets = this.registry.getServlets();
        String rowClass = "odd";
        for (ServletHandler servlet : servlets) {
            pw.println("<tr class=\"" + rowClass + " ui-state-default\">");
            pw.println("<td>" + servlet.getAlias() + "</td>");
            pw.println("<td>" + servlet.getServlet().getClass().getName() + "</td>");
            this.printBundleDetails(pw, servlet.getServlet().getClass());
            pw.println("</tr>");
            rowClass = rowClass.equals("odd") ? "even" : "odd";
        }
        pw.println("</table>");
    }

    public void printConfiguration(PrintWriter pw) {
        ServletHandler[] servlets;
        pw.println("HTTP Service Details:");
        pw.println();
        pw.println("Registered Servlet Services");
        for (ServletHandler servlet : servlets = this.registry.getServlets()) {
            pw.println("Alias : " + servlet.getAlias());
            HttpServicePlugin.addSpace(pw, 1);
            pw.println("Class  :" + servlet.getServlet().getClass().getName());
            HttpServicePlugin.addSpace(pw, 1);
            pw.println("Bundle :" + this.getBundleDetails(servlet.getServlet().getClass()));
        }
        pw.println();
        pw.println("Registered Filter Services");
        Object[] filters = this.registry.getFilters();
        Arrays.sort(filters);
        for (Object filter : filters) {
            pw.println("Pattern : " + ((FilterHandler)filter).getPattern());
            HttpServicePlugin.addSpace(pw, 1);
            pw.println("Ranking :" + ((FilterHandler)filter).getRanking());
            HttpServicePlugin.addSpace(pw, 1);
            pw.println("Class   :" + ((FilterHandler)filter).getFilter().getClass().getName());
            HttpServicePlugin.addSpace(pw, 1);
            pw.println("Bundle  :" + this.getBundleDetails(((FilterHandler)filter).getFilter().getClass()));
        }
    }

    public void unregister() {
        if (this.serviceReg != null) {
            this.serviceReg.unregister();
        }
    }

    private void printBundleDetails(PrintWriter pw, Class<?> c) {
        Bundle b = this.getBundle(c);
        pw.println("<td>");
        if (b == null) {
            pw.print("UNKNOWN");
        } else {
            String details = b.getSymbolicName();
            pw.print("<a href=\"${appRoot}/bundles/" + b.getBundleId() + "\">" + details + "</a>");
        }
        pw.println("</td>");
    }

    private String getBundleDetails(Class<?> c) {
        Bundle b = this.getBundle(c);
        return b == null ? "UNKNOWN" : b.getSymbolicName();
    }

    private static void addSpace(PrintWriter pw, int count) {
        for (int i = 0; i < count; ++i) {
            pw.print("  ");
        }
    }

    private Bundle getBundle(Class<?> clazz) {
        return FrameworkUtil.getBundle(clazz);
    }
}

