/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.runtime.osgi.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import org.jboss.gravia.runtime.Module;
import org.jboss.gravia.runtime.ModuleEvent;
import org.jboss.gravia.runtime.ModuleListener;
import org.jboss.gravia.runtime.Runtime;
import org.jboss.gravia.runtime.ServiceEvent;
import org.jboss.gravia.runtime.ServiceFactory;
import org.jboss.gravia.runtime.ServiceListener;
import org.jboss.gravia.runtime.ServiceReference;
import org.jboss.gravia.runtime.ServiceRegistration;
import org.jboss.gravia.runtime.SynchronousModuleListener;
import org.jboss.gravia.runtime.osgi.internal.OSGiRuntime;
import org.jboss.gravia.runtime.spi.AbstractModuleContext;
import org.jboss.gravia.utils.IllegalArgumentAssertion;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.SynchronousBundleListener;

final class ModuleContextAdaptor
extends AbstractModuleContext {
    private final BundleContext bundleContext;
    private static Map<Integer, Integer> eventMapping = new HashMap<Integer, Integer>();

    ModuleContextAdaptor(Module module, BundleContext bundleContext) {
        super(module);
        IllegalArgumentAssertion.assertNotNull((Object)bundleContext, (String)"bundleContext");
        this.bundleContext = bundleContext;
    }

    public void addModuleListener(ModuleListener listener) {
        this.bundleContext.addBundleListener(this.adaptModuleListener(listener));
    }

    public void removeModuleListener(ModuleListener listener) {
        this.bundleContext.removeBundleListener(this.adaptModuleListener(listener));
    }

    public void addServiceListener(ServiceListener listener, String filter) {
        try {
            this.bundleContext.addServiceListener((org.osgi.framework.ServiceListener)new ServiceListenerAdaptor(listener), filter);
        }
        catch (InvalidSyntaxException ex) {
            throw new IllegalArgumentException(filter, ex);
        }
    }

    public void addServiceListener(ServiceListener listener) {
        this.bundleContext.addServiceListener((org.osgi.framework.ServiceListener)new ServiceListenerAdaptor(listener));
    }

    public void removeServiceListener(ServiceListener listener) {
        this.bundleContext.removeServiceListener((org.osgi.framework.ServiceListener)new ServiceListenerAdaptor(listener));
    }

    public <S> ServiceRegistration<S> registerService(Class<S> clazz, S service, Dictionary<String, ?> properties) {
        return new ServiceRegistrationAdaptor(this.bundleContext.registerService(clazz, this.adaptServiceFactory(service), properties));
    }

    public ServiceRegistration<?> registerService(String className, Object service, Dictionary<String, ?> properties) {
        return new ServiceRegistrationAdaptor(this.bundleContext.registerService(className, this.adaptServiceFactory(service), properties));
    }

    public ServiceRegistration<?> registerService(String[] classNames, Object service, Dictionary<String, ?> properties) {
        return new ServiceRegistrationAdaptor(this.bundleContext.registerService(classNames, this.adaptServiceFactory(service), properties));
    }

    public <S> ServiceReference<S> getServiceReference(Class<S> clazz) {
        org.osgi.framework.ServiceReference sref = this.bundleContext.getServiceReference(clazz);
        return sref != null ? new ServiceReferenceAdaptor(sref) : null;
    }

    public ServiceReference<?> getServiceReference(String className) {
        org.osgi.framework.ServiceReference sref = this.bundleContext.getServiceReference(className);
        return sref != null ? new ServiceReferenceAdaptor(sref) : null;
    }

    public <S> Collection<ServiceReference<S>> getServiceReferences(Class<S> clazz, String filter) {
        Collection srefs;
        try {
            srefs = this.bundleContext.getServiceReferences(clazz, filter);
        }
        catch (InvalidSyntaxException ex) {
            throw new IllegalArgumentException(filter, ex);
        }
        ArrayList result = new ArrayList();
        for (org.osgi.framework.ServiceReference sref : srefs) {
            result.add(new ServiceReferenceAdaptor(sref));
        }
        return Collections.unmodifiableList(result);
    }

    public ServiceReference<?>[] getServiceReferences(String className, String filter) {
        org.osgi.framework.ServiceReference[] srefs;
        try {
            srefs = this.bundleContext.getServiceReferences(className, filter);
        }
        catch (InvalidSyntaxException ex) {
            throw new IllegalArgumentException(filter, ex);
        }
        if (srefs == null) {
            return null;
        }
        ArrayList result = new ArrayList();
        for (org.osgi.framework.ServiceReference sref : srefs) {
            result.add(new ServiceReferenceAdaptor(sref));
        }
        return result.toArray(new ServiceReference[result.size()]);
    }

    public ServiceReference<?>[] getAllServiceReferences(String className, String filter) {
        org.osgi.framework.ServiceReference[] srefs;
        try {
            srefs = this.bundleContext.getAllServiceReferences(className, filter);
        }
        catch (InvalidSyntaxException ex) {
            throw new IllegalArgumentException(filter, ex);
        }
        if (srefs == null) {
            return null;
        }
        ArrayList result = new ArrayList();
        for (org.osgi.framework.ServiceReference sref : srefs) {
            result.add(new ServiceReferenceAdaptor(sref));
        }
        return result.toArray(new ServiceReference[result.size()]);
    }

    public <S> S getService(ServiceReference<S> reference) {
        ServiceReferenceAdaptor adaptor = (ServiceReferenceAdaptor)reference;
        return (S)this.bundleContext.getService(adaptor.delegate);
    }

    public boolean ungetService(ServiceReference<?> reference) {
        ServiceReferenceAdaptor adaptor = (ServiceReferenceAdaptor)reference;
        return this.bundleContext.ungetService(adaptor.delegate);
    }

    private Module mappedModule(Bundle bundle) {
        OSGiRuntime runtime = (OSGiRuntime)((Object)this.getModule().adapt(Runtime.class));
        return runtime.getModule(bundle);
    }

    private <S> S adaptServiceFactory(S service) {
        if (service instanceof ServiceFactory) {
            ServiceFactory factory = (ServiceFactory)service;
            service = new ServiceFactoryAdaptor(factory);
        }
        return service;
    }

    private BundleListener adaptModuleListener(ModuleListener listener) {
        if (listener instanceof SynchronousModuleListener) {
            return new SynchronousModuleListenerAdaptor(listener);
        }
        return new ModuleListenerAdaptor(listener);
    }

    static {
        eventMapping.put(32, 1);
        eventMapping.put(128, 128);
        eventMapping.put(2, 2);
        eventMapping.put(256, 256);
        eventMapping.put(4, 4);
        eventMapping.put(64, 16);
    }

    private class ServiceFactoryAdaptor<S>
    implements org.osgi.framework.ServiceFactory<S> {
        private final ServiceFactory<S> delegate;

        ServiceFactoryAdaptor(ServiceFactory<S> delegate) {
            IllegalArgumentAssertion.assertNotNull(delegate, (String)"delegate");
            this.delegate = delegate;
        }

        public S getService(Bundle bundle, org.osgi.framework.ServiceRegistration<S> registration) {
            return (S)this.delegate.getService(ModuleContextAdaptor.this.mappedModule(bundle), new ServiceRegistrationAdaptor<S>(registration));
        }

        public void ungetService(Bundle bundle, org.osgi.framework.ServiceRegistration<S> registration, S service) {
            this.delegate.ungetService(ModuleContextAdaptor.this.mappedModule(bundle), new ServiceRegistrationAdaptor<S>(registration), service);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ServiceFactoryAdaptor)) {
                return false;
            }
            ServiceFactoryAdaptor other = (ServiceFactoryAdaptor)obj;
            return this.delegate.equals(other.delegate);
        }

        public String toString() {
            return this.delegate.toString();
        }
    }

    private class ServiceRegistrationAdaptor<S>
    implements ServiceRegistration<S> {
        private final org.osgi.framework.ServiceRegistration<S> delegate;

        ServiceRegistrationAdaptor(org.osgi.framework.ServiceRegistration<S> delegate) {
            IllegalArgumentAssertion.assertNotNull(delegate, (String)"delegate");
            this.delegate = delegate;
        }

        public ServiceReference<S> getReference() {
            return new ServiceReferenceAdaptor(this.delegate.getReference());
        }

        public void setProperties(Dictionary<String, ?> properties) {
            this.delegate.setProperties(properties);
        }

        public void unregister() {
            this.delegate.unregister();
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ServiceRegistrationAdaptor)) {
                return false;
            }
            ServiceRegistrationAdaptor other = (ServiceRegistrationAdaptor)obj;
            return this.delegate.equals(other.delegate);
        }

        public String toString() {
            return this.delegate.toString();
        }
    }

    private class ServiceReferenceAdaptor<S>
    implements ServiceReference<S> {
        private final org.osgi.framework.ServiceReference<S> delegate;

        ServiceReferenceAdaptor(org.osgi.framework.ServiceReference<S> delegate) {
            IllegalArgumentAssertion.assertNotNull(delegate, (String)"delegate");
            this.delegate = delegate;
        }

        public Object getProperty(String key) {
            return this.delegate.getProperty(key);
        }

        public String[] getPropertyKeys() {
            return this.delegate.getPropertyKeys();
        }

        public Module getModule() {
            Bundle bundle = this.delegate.getBundle();
            return ModuleContextAdaptor.this.mappedModule(bundle);
        }

        public boolean isAssignableTo(Module module, String className) {
            return this.delegate.isAssignableTo((Bundle)module.adapt(Bundle.class), className);
        }

        public int compareTo(Object reference) {
            return new ServiceReferenceAdaptor<S>(this.delegate).compareTo(reference);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ServiceReferenceAdaptor)) {
                return false;
            }
            ServiceReferenceAdaptor other = (ServiceReferenceAdaptor)obj;
            return this.delegate.equals(other.delegate);
        }

        public String toString() {
            return this.delegate.toString();
        }
    }

    private class ServiceListenerAdaptor
    implements org.osgi.framework.ServiceListener {
        private final ServiceListener delegate;

        ServiceListenerAdaptor(ServiceListener delegate) {
            IllegalArgumentAssertion.assertNotNull((Object)delegate, (String)"delegate");
            this.delegate = delegate;
        }

        public void serviceChanged(org.osgi.framework.ServiceEvent event) {
            ServiceReferenceAdaptor sref = new ServiceReferenceAdaptor(event.getServiceReference());
            this.delegate.serviceChanged(new ServiceEvent(event.getType(), sref));
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ServiceListenerAdaptor)) {
                return false;
            }
            ServiceListenerAdaptor other = (ServiceListenerAdaptor)obj;
            return this.delegate.equals(other.delegate);
        }

        public String toString() {
            return this.delegate.toString();
        }
    }

    private class ModuleListenerAdaptor
    implements BundleListener {
        private final ModuleListener delegate;

        ModuleListenerAdaptor(ModuleListener delegate) {
            IllegalArgumentAssertion.assertNotNull((Object)delegate, (String)"delegate");
            this.delegate = delegate;
        }

        public void bundleChanged(BundleEvent event) {
            Integer bndtype = event.getType();
            Module module = ModuleContextAdaptor.this.mappedModule(event.getBundle());
            Integer modtype = (Integer)eventMapping.get(bndtype);
            if (module != null && modtype != null) {
                ModuleEvent moduleEvent = new ModuleEvent(modtype.intValue(), module);
                this.delegate.moduleChanged(moduleEvent);
            }
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ModuleListenerAdaptor)) {
                return false;
            }
            ModuleListenerAdaptor other = (ModuleListenerAdaptor)obj;
            return this.delegate.equals(other.delegate);
        }

        public String toString() {
            return this.delegate.toString();
        }
    }

    private class SynchronousModuleListenerAdaptor
    extends ModuleListenerAdaptor
    implements SynchronousBundleListener {
        SynchronousModuleListenerAdaptor(ModuleListener delegate) {
            super(delegate);
        }
    }
}

