/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.resource;

import org.jboss.gravia.resource.Version;
import org.jboss.gravia.utils.IllegalArgumentAssertion;

public final class ResourceIdentity {
    private final String symbolicName;
    private final Version version;
    private final String canonicalForm;

    public static ResourceIdentity create(String symbolicName, String version) {
        return new ResourceIdentity(symbolicName, version != null ? Version.parseVersion(version) : null);
    }

    public static ResourceIdentity create(String symbolicName, Version version) {
        return new ResourceIdentity(symbolicName, version);
    }

    public static ResourceIdentity fromString(String identity) {
        int index = identity.indexOf(58);
        String namePart = index > 0 ? identity.substring(0, index) : identity;
        String versionPart = index > 0 ? identity.substring(index + 1) : "0.0.0";
        return new ResourceIdentity(namePart, Version.parseVersion(versionPart));
    }

    private ResourceIdentity(String symbolicName, Version version) {
        IllegalArgumentAssertion.assertNotNull(symbolicName, "symbolicName");
        this.symbolicName = symbolicName;
        this.version = version != null ? version : Version.emptyVersion;
        this.canonicalForm = symbolicName + ":" + version;
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public Version getVersion() {
        return this.version;
    }

    public String getCanonicalForm() {
        return this.canonicalForm;
    }

    public int hashCode() {
        return this.canonicalForm.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ResourceIdentity)) {
            return false;
        }
        ResourceIdentity other = (ResourceIdentity)obj;
        return this.canonicalForm.equals(other.canonicalForm);
    }

    public String toString() {
        return this.canonicalForm;
    }
}

