/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.provision.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.gravia.provision.ResourceInstaller;
import org.jboss.gravia.resource.Requirement;
import org.jboss.gravia.resource.Resource;
import org.jboss.gravia.utils.IllegalArgumentAssertion;

public class DefaultInstallerContext
implements ResourceInstaller.Context {
    private final List<Resource> resources;
    private final Map<Requirement, Resource> resourceMapping;
    private final Map<String, Object> properties = new HashMap<String, Object>();

    public DefaultInstallerContext(Resource resource) {
        this(Collections.singletonList(resource), Collections.emptyMap());
    }

    public DefaultInstallerContext(List<Resource> resources, Map<Requirement, Resource> mapping) {
        IllegalArgumentAssertion.assertNotNull(resources, (String)"resources");
        IllegalArgumentAssertion.assertNotNull(mapping, (String)"mapping");
        this.resources = new ArrayList<Resource>(resources);
        this.resourceMapping = new HashMap<Requirement, Resource>(mapping);
    }

    @Override
    public List<Resource> getResources() {
        return Collections.unmodifiableList(this.resources);
    }

    @Override
    public Map<Requirement, Resource> getResourceMapping() {
        return Collections.unmodifiableMap(this.resourceMapping);
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }
}

