/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.common;

import java.io.Serializable;
import java.text.ParseException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cometd.bayeux.ChannelId;
import org.cometd.bayeux.Message;
import org.cometd.common.JSONContext;
import org.cometd.common.JettyJSONContextClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashMapMessage
extends HashMap<String, Object>
implements Message.Mutable,
Serializable {
    private static final long serialVersionUID = 4318697940670212190L;
    private static JSONContext.Client _jsonContext = new JettyJSONContextClient();

    public HashMapMessage() {
    }

    public HashMapMessage(Message message) {
        this.putAll(message);
    }

    @Override
    public Map<String, Object> getAdvice() {
        return (Map)this.get("advice");
    }

    @Override
    public String getChannel() {
        return (String)this.get("channel");
    }

    @Override
    public ChannelId getChannelId() {
        return new ChannelId(this.getChannel());
    }

    @Override
    public String getClientId() {
        return (String)this.get("clientId");
    }

    @Override
    public Object getData() {
        return this.get("data");
    }

    @Override
    public Map<String, Object> getDataAsMap() {
        return (Map)this.get("data");
    }

    @Override
    public Map<String, Object> getExt() {
        return (Map)this.get("ext");
    }

    @Override
    public String getId() {
        Object id = this.get("id");
        return id == null ? null : String.valueOf(id);
    }

    @Override
    public String getJSON() {
        return _jsonContext.generate(this);
    }

    @Override
    public Map<String, Object> getAdvice(boolean create) {
        Map<String, Object> advice = this.getAdvice();
        if (create && advice == null) {
            advice = new HashMap<String, Object>(4);
            this.put("advice", advice);
        }
        return advice;
    }

    @Override
    public Map<String, Object> getDataAsMap(boolean create) {
        Map<String, Object> data = this.getDataAsMap();
        if (create && data == null) {
            data = new HashMap<String, Object>();
            this.put("data", data);
        }
        return data;
    }

    @Override
    public Map<String, Object> getExt(boolean create) {
        Map<String, Object> ext = this.getExt();
        if (create && ext == null) {
            ext = new HashMap<String, Object>();
            this.put("ext", ext);
        }
        return ext;
    }

    @Override
    public boolean isMeta() {
        return ChannelId.isMeta(this.getChannel());
    }

    @Override
    public boolean isSuccessful() {
        Boolean value = (Boolean)this.get("successful");
        return value != null && value != false;
    }

    @Override
    public void setChannel(String channel) {
        if (channel == null) {
            this.remove("channel");
        } else {
            this.put("channel", channel);
        }
    }

    @Override
    public void setClientId(String clientId) {
        if (clientId == null) {
            this.remove("clientId");
        } else {
            this.put("clientId", clientId);
        }
    }

    @Override
    public void setData(Object data) {
        if (data == null) {
            this.remove("data");
        } else {
            this.put("data", data);
        }
    }

    @Override
    public void setId(String id) {
        if (id == null) {
            this.remove("id");
        } else {
            this.put("id", id);
        }
    }

    @Override
    public void setSuccessful(boolean successful) {
        this.put("successful", successful);
    }

    @Deprecated
    public static List<Message.Mutable> parseMessages(String content) {
        try {
            return Arrays.asList(_jsonContext.parse(content));
        }
        catch (ParseException x) {
            throw new RuntimeException(x);
        }
    }
}

