/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.runtime.spi;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.gravia.runtime.spi.PropertiesProvider;
import org.jboss.gravia.utils.IllegalArgumentAssertion;

public class MapPropertiesProvider
implements PropertiesProvider {
    private final Map<String, Object> properties = new ConcurrentHashMap<String, Object>();

    public MapPropertiesProvider() {
        this(new HashMap<String, Object>());
    }

    public MapPropertiesProvider(Properties props) {
        this(MapPropertiesProvider.propsToMap(props));
    }

    public MapPropertiesProvider(Map<String, Object> props) {
        IllegalArgumentAssertion.assertNotNull(props, (String)"props");
        this.properties.putAll(props);
    }

    @Override
    public Object getProperty(String key) {
        return this.getProperty(key, null);
    }

    @Override
    public Object getProperty(String key, Object defaultValue) {
        Object value = this.properties.get(key);
        return value != null ? value : defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Object> propsToMap(Properties props) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Properties properties = props;
        synchronized (properties) {
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                String key = entry.getKey().toString();
                Object value = entry.getValue();
                result.put(key, value);
            }
        }
        return result;
    }
}

