/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.common;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.Map;
import org.cometd.bayeux.Message;
import org.eclipse.jetty.util.ajax.JSON;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JettyJSONContext<T extends Message.Mutable> {
    private FieldJSON _jsonParser = new FieldJSON();
    private FieldJSON _messageParser = new MessageJSON();
    private FieldJSON _messagesParser = new MessagesJSON();

    protected JettyJSONContext() {
    }

    public JSON getJSON() {
        return this._jsonParser;
    }

    protected abstract T newRoot();

    protected abstract T[] newRootArray(int var1);

    public T[] parse(InputStream stream) throws ParseException {
        return this.parse(new InputStreamReader(stream, Charset.forName("UTF-8")));
    }

    public T[] parse(Reader reader) throws ParseException {
        try {
            Object object = this._messagesParser.parse(new JSON.ReaderSource(reader));
            return this.adapt(object);
        }
        catch (Exception x) {
            throw (ParseException)new ParseException("", -1).initCause(x);
        }
    }

    public T[] parse(String json) throws ParseException {
        try {
            Object object = this._messagesParser.parse(new JSON.StringSource(json));
            return this.adapt(object);
        }
        catch (Exception x) {
            throw (ParseException)new ParseException(json, -1).initCause(x);
        }
    }

    private T[] adapt(Object object) {
        if (object == null) {
            return null;
        }
        if (object.getClass().isArray()) {
            return (Message.Mutable[])object;
        }
        Message.Mutable[] result = this.newRootArray(1);
        result[0] = (Message.Mutable)object;
        return result;
    }

    public String generate(T message) {
        return this._messageParser.toJSON(message);
    }

    public String generate(T[] messages) {
        return this._messagesParser.toJSON(messages);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MessagesJSON
    extends FieldJSON {
        private MessagesJSON() {
        }

        @Override
        protected Map<String, Object> newMap() {
            return JettyJSONContext.this.newRoot();
        }

        @Override
        protected Object[] newArray(int size) {
            return JettyJSONContext.this.newRootArray(size);
        }

        @Override
        protected JSON contextFor(String field) {
            return JettyJSONContext.this.getJSON();
        }

        @Override
        protected JSON contextForArray() {
            return JettyJSONContext.this._messageParser;
        }

        @Override
        protected JSON.Convertor getConvertor(Class forClass) {
            return JettyJSONContext.this._messageParser.getConvertor(forClass);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MessageJSON
    extends FieldJSON {
        private MessageJSON() {
        }

        @Override
        protected Map<String, Object> newMap() {
            return JettyJSONContext.this.newRoot();
        }

        @Override
        protected JSON contextFor(String field) {
            return JettyJSONContext.this.getJSON();
        }

        @Override
        protected JSON.Convertor getConvertor(Class forClass) {
            return JettyJSONContext.this._jsonParser.getConvertor(forClass);
        }
    }

    private class FieldJSON
    extends JSON {
        private FieldJSON() {
        }

        protected JSON.Convertor getConvertor(Class forClass) {
            return super.getConvertor(forClass);
        }
    }
}

