/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.scr.Component;
import org.apache.felix.scr.ScrService;
import org.apache.felix.scr.impl.BundleComponentActivator;
import org.apache.felix.scr.impl.ComponentActorThread;
import org.apache.felix.scr.impl.ComponentRegistryKey;
import org.apache.felix.scr.impl.config.ComponentHolder;
import org.apache.felix.scr.impl.config.ConfigurationSupport;
import org.apache.felix.scr.impl.config.ImmediateComponentHolder;
import org.apache.felix.scr.impl.manager.AbstractComponentManager;
import org.apache.felix.scr.impl.manager.ComponentFactoryImpl;
import org.apache.felix.scr.impl.manager.ConfigurationComponentFactoryImpl;
import org.apache.felix.scr.impl.manager.DependencyManager;
import org.apache.felix.scr.impl.metadata.ComponentMetadata;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentException;

public class ComponentRegistry
implements ScrService,
ServiceListener {
    public static final String CONFIGURATION_ADMIN = "org.osgi.service.cm.ConfigurationAdmin";
    private BundleContext m_bundleContext;
    private final Map m_componentHoldersByName;
    private final Map m_componentHoldersByPid;
    private final Map m_componentsById;
    private volatile long m_componentCounter;
    private ServiceRegistration m_registration;
    private ConfigurationSupport configurationSupport;
    private final Map m_missingDependencies = new HashMap();

    protected ComponentRegistry(BundleContext context) {
        this.m_bundleContext = context;
        this.m_componentHoldersByName = new HashMap();
        this.m_componentHoldersByPid = new HashMap();
        this.m_componentsById = new HashMap();
        this.m_componentCounter = -1L;
        try {
            context.addServiceListener((ServiceListener)this, "(objectclass=org.osgi.service.cm.ConfigurationAdmin)");
        }
        catch (InvalidSyntaxException ise) {
            // empty catch block
        }
        if (context.getServiceReference(CONFIGURATION_ADMIN) != null) {
            this.getOrCreateConfigurationSupport();
        }
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.description", "Declarative Services Management Agent");
        ((Dictionary)props).put("service.vendor", "The Apache Software Foundation");
        this.m_registration = context.registerService(new String[]{ScrService.class.getName()}, (Object)this, props);
    }

    public void dispose() {
        this.m_bundleContext.removeServiceListener((ServiceListener)this);
        if (this.configurationSupport != null) {
            this.configurationSupport.dispose();
            this.configurationSupport = null;
        }
        if (this.m_registration != null) {
            this.m_registration.unregister();
            this.m_registration = null;
        }
    }

    public Component[] getComponents() {
        Object[] holders = this.getComponentHolders();
        ArrayList<Component> list = new ArrayList<Component>();
        for (int i = 0; i < holders.length; ++i) {
            if (!(holders[i] instanceof ComponentHolder)) continue;
            Component[] components = ((ComponentHolder)holders[i]).getComponents();
            for (int j = 0; j < components.length; ++j) {
                list.add(components[j]);
            }
        }
        if (list.isEmpty()) {
            return null;
        }
        return list.toArray(new Component[list.size()]);
    }

    public Component[] getComponents(Bundle bundle) {
        Object[] holders = this.getComponentHolders();
        ArrayList<Component> list = new ArrayList<Component>();
        for (int i = 0; i < holders.length; ++i) {
            ComponentHolder holder;
            BundleComponentActivator activator;
            if (!(holders[i] instanceof ComponentHolder) || (activator = (holder = (ComponentHolder)holders[i]).getActivator()) == null || activator.getBundleContext().getBundle() != bundle) continue;
            Component[] components = holder.getComponents();
            for (int j = 0; j < components.length; ++j) {
                list.add(components[j]);
            }
        }
        if (list.isEmpty()) {
            return null;
        }
        return list.toArray(new Component[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getComponent(long componentId) {
        Map map = this.m_componentsById;
        synchronized (map) {
            return (Component)this.m_componentsById.get(new Long(componentId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component[] getComponents(String componentName) {
        ArrayList<Component> list = new ArrayList<Component>();
        Map map = this.m_componentHoldersByName;
        synchronized (map) {
            for (ComponentHolder c : this.m_componentHoldersByName.values()) {
                if (!componentName.equals(c.getComponentMetadata().getName())) continue;
                list.addAll(Arrays.asList(c.getComponents()));
            }
        }
        return list.isEmpty() ? null : list.toArray(new Component[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final long registerComponentId(AbstractComponentManager componentManager) {
        long componentId;
        Map map = this.m_componentsById;
        synchronized (map) {
            ++this.m_componentCounter;
            componentId = this.m_componentCounter;
            this.m_componentsById.put(new Long(componentId), componentManager);
        }
        return componentId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void unregisterComponentId(long componentId) {
        Map map = this.m_componentsById;
        synchronized (map) {
            this.m_componentsById.remove(new Long(componentId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ComponentRegistryKey checkComponentName(Bundle bundle, String name) {
        Object existingRegistration;
        ComponentRegistryKey key = new ComponentRegistryKey(bundle, name);
        Map map = this.m_componentHoldersByName;
        synchronized (map) {
            existingRegistration = this.m_componentHoldersByName.get(key);
            if (existingRegistration == null) {
                this.m_componentHoldersByName.put(key, key);
            }
        }
        if (existingRegistration != null) {
            String message = "The component name '" + name + "' has already been registered";
            if (existingRegistration instanceof ComponentHolder) {
                ComponentHolder c = (ComponentHolder)existingRegistration;
                Bundle cBundle = c.getActivator().getBundleContext().getBundle();
                ComponentMetadata cMeta = c.getComponentMetadata();
                StringBuffer buf = new StringBuffer(message);
                buf.append(" by Bundle ").append(cBundle.getBundleId());
                if (cBundle.getSymbolicName() != null) {
                    buf.append(" (").append(cBundle.getSymbolicName()).append(")");
                }
                buf.append(" as Component of Class ").append(cMeta.getImplementationClassName());
                message = buf.toString();
            }
            throw new ComponentException(message);
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void registerComponentHolder(ComponentRegistryKey key, ComponentHolder component) {
        Map map = this.m_componentHoldersByName;
        synchronized (map) {
            if (!key.equals(this.m_componentHoldersByName.get(key))) {
                throw new ComponentException("The component name '" + component.getComponentMetadata().getName() + "' has already been registered.");
            }
            this.m_componentHoldersByName.put(key, component);
        }
        map = this.m_componentHoldersByPid;
        synchronized (map) {
            String configurationPid = component.getComponentMetadata().getConfigurationPid();
            HashSet<ComponentHolder> set = (HashSet<ComponentHolder>)this.m_componentHoldersByPid.get(configurationPid);
            if (set == null) {
                set = new HashSet<ComponentHolder>();
                this.m_componentHoldersByPid.put(configurationPid, set);
            }
            set.add(component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ComponentHolder getComponentHolder(Bundle bundle, String name) {
        Object entry;
        Map map = this.m_componentHoldersByName;
        synchronized (map) {
            entry = this.m_componentHoldersByName.get(new ComponentRegistryKey(bundle, name));
        }
        if (entry instanceof ComponentHolder) {
            return (ComponentHolder)entry;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Iterator getComponentHoldersByPid(String pid) {
        HashSet componentHoldersUsingPid = new HashSet();
        Map map = this.m_componentHoldersByPid;
        synchronized (map) {
            Set set = (Set)this.m_componentHoldersByPid.get(pid);
            if (set != null) {
                componentHoldersUsingPid.addAll(set);
            }
        }
        return componentHoldersUsingPid.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] getComponentHolders() {
        Map map = this.m_componentHoldersByName;
        synchronized (map) {
            return this.m_componentHoldersByName.values().toArray();
        }
    }

    final void unregisterComponentHolder(Bundle bundle, String name) {
        this.unregisterComponentHolder(new ComponentRegistryKey(bundle, name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void unregisterComponentHolder(ComponentRegistryKey key) {
        Object component;
        Map map = this.m_componentHoldersByName;
        synchronized (map) {
            component = this.m_componentHoldersByName.remove(key);
        }
        if (component instanceof ComponentHolder) {
            map = this.m_componentHoldersByPid;
            synchronized (map) {
                String configurationPid = ((ComponentHolder)component).getComponentMetadata().getConfigurationPid();
                Set componentsForPid = (Set)this.m_componentHoldersByPid.get(configurationPid);
                if (componentsForPid != null) {
                    componentsForPid.remove(component);
                    if (componentsForPid.size() == 0) {
                        this.m_componentHoldersByPid.remove(configurationPid);
                    }
                }
            }
        }
    }

    public ComponentHolder createComponentHolder(BundleComponentActivator activator, ComponentMetadata metadata) {
        ComponentHolder holder = metadata.isFactory() ? (!activator.getConfiguration().isFactoryEnabled() ? new ComponentFactoryImpl(activator, metadata) : new ConfigurationComponentFactoryImpl(activator, metadata)) : new ImmediateComponentHolder(activator, metadata);
        if (this.configurationSupport != null) {
            this.configurationSupport.configureComponentHolder(holder);
        }
        return holder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceChanged(ServiceEvent event) {
        if (event.getType() == 1) {
            ConfigurationSupport configurationSupport = this.getOrCreateConfigurationSupport();
            ServiceReference caRef = event.getServiceReference();
            Object service = this.m_bundleContext.getService(caRef);
            if (service != null) {
                try {
                    configurationSupport.configureComponentHolders((ServiceReference<ConfigurationAdmin>)caRef, service);
                }
                finally {
                    this.m_bundleContext.ungetService(caRef);
                }
            }
        } else if (event.getType() == 4) {
            this.disposeConfigurationSupport();
        }
    }

    static boolean isBundleActive(Bundle bundle) {
        if (bundle != null) {
            if (bundle.getState() == 32) {
                return true;
            }
            if (bundle.getState() == 8) {
                return bundle.getHeaders().get("Bundle-ActivationPolicy") != null;
            }
        }
        return false;
    }

    private ConfigurationSupport getOrCreateConfigurationSupport() {
        if (this.configurationSupport == null) {
            this.configurationSupport = new ConfigurationSupport(this.m_bundleContext, this);
        }
        return this.configurationSupport;
    }

    private void disposeConfigurationSupport() {
        if (this.configurationSupport != null) {
            this.configurationSupport.dispose();
            this.configurationSupport = null;
        }
    }

    public void missingServicePresent(final ServiceReference serviceReference, ComponentActorThread actor) {
        final List dependencyManagers = (List)this.m_missingDependencies.remove(serviceReference);
        if (dependencyManagers != null) {
            actor.schedule(new Runnable(){

                public void run() {
                    for (DependencyManager dm : dependencyManagers) {
                        dm.invokeBindMethodLate(serviceReference);
                    }
                }
            });
        }
    }

    public synchronized void registerMissingDependency(DependencyManager dependencyManager, ServiceReference serviceReference) {
        if (serviceReference.getProperty("component.name") == null || serviceReference.getProperty("component.id") == null) {
            return;
        }
        ArrayList<DependencyManager> dependencyManagers = (ArrayList<DependencyManager>)this.m_missingDependencies.get(serviceReference);
        if (dependencyManagers == null) {
            dependencyManagers = new ArrayList<DependencyManager>();
            this.m_missingDependencies.put(serviceReference, dependencyManagers);
        }
        dependencyManagers.add(dependencyManager);
    }
}

