/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.runtime.osgi.internal;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.jboss.gravia.resource.Attachable;
import org.jboss.gravia.resource.DefaultResourceBuilder;
import org.jboss.gravia.resource.DictionaryResourceBuilder;
import org.jboss.gravia.resource.Resource;
import org.jboss.gravia.runtime.Module;
import org.jboss.gravia.runtime.ModuleContext;
import org.jboss.gravia.runtime.ModuleException;
import org.jboss.gravia.runtime.Runtime;
import org.jboss.gravia.runtime.ServiceReference;
import org.jboss.gravia.runtime.ServiceRegistration;
import org.jboss.gravia.runtime.osgi.internal.ModuleAdaptor;
import org.jboss.gravia.runtime.spi.AbstractModule;
import org.jboss.gravia.runtime.spi.AbstractRuntime;
import org.jboss.gravia.runtime.spi.ModuleEntriesProvider;
import org.jboss.gravia.runtime.spi.PropertiesProvider;
import org.jboss.gravia.runtime.spi.RuntimeLogger;
import org.jboss.gravia.runtime.spi.ThreadResourceAssociation;
import org.jboss.gravia.runtime.spi.URLStreamHandlerTracker;
import org.jboss.gravia.utils.IllegalArgumentAssertion;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.url.AbstractURLStreamHandlerService;
import org.osgi.service.url.URLStreamHandlerService;

public final class OSGiRuntime
extends AbstractRuntime {
    private final BundleContext context;
    private final BundleListener installListener;
    private final URLStreamHandlerTracker streamHandlerTracker;
    private final Map<Long, Module> uninstalled = new HashMap<Long, Module>();

    public OSGiRuntime(BundleContext context, PropertiesProvider propertiesProvider) {
        super(propertiesProvider);
        IllegalArgumentAssertion.assertNotNull((Object)context, (String)"context");
        this.context = context;
        Bundle sysbundle = context.getBundle(0L);
        try {
            Resource resource = new DefaultResourceBuilder().addIdentityCapability(this.getSystemIdentity()).getResource();
            BundleWiring wiring = (BundleWiring)sysbundle.adapt(BundleWiring.class);
            this.installModule(wiring.getClassLoader(), resource, sysbundle.getHeaders(), null);
        }
        catch (ModuleException ex) {
            throw new IllegalStateException("Cannot install system module", ex);
        }
        this.streamHandlerTracker = this.createURLStreamHandlerTracker(this.getModuleContext());
        this.installListener = this.createBundleInstallListener();
    }

    private URLStreamHandlerTracker createURLStreamHandlerTracker(ModuleContext moduleContext) {
        URLStreamHandlerTracker tracker = new URLStreamHandlerTracker(moduleContext){
            private Map<ServiceReference<?>, ServiceRegistration<?>> registrations;
            {
                this.registrations = new HashMap();
            }

            protected void addingHandler(String protocol, ServiceReference<URLStreamHandler> sref, final URLStreamHandler handler) {
                AbstractURLStreamHandlerService service = new AbstractURLStreamHandlerService(){

                    public URLConnection openConnection(URL url) throws IOException {
                        return new URL(null, url.toExternalForm(), handler).openConnection();
                    }
                };
                Hashtable<String, Object> props = new Hashtable<String, Object>();
                for (String key : sref.getPropertyKeys()) {
                    if (key.equals("service.id")) continue;
                    ((Dictionary)props).put(key, sref.getProperty(key));
                }
                ServiceRegistration sreg = OSGiRuntime.this.getModuleContext().registerService(URLStreamHandlerService.class, (Object)service, props);
                this.registrations.put(sref, sreg);
            }

            protected void removingHandler(String protocol, ServiceReference<URLStreamHandler> sref, URLStreamHandler handler) {
                ServiceRegistration<?> sreg = this.registrations.remove(sref);
                if (sreg != null) {
                    sreg.unregister();
                }
            }
        };
        return tracker;
    }

    private BundleListener createBundleInstallListener() {
        return new SynchronousBundleListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void bundleChanged(BundleEvent event) {
                Module module;
                int eventType = event.getType();
                Bundle bundle = event.getBundle();
                if (eventType == 32) {
                    OSGiRuntime.this.installModule(bundle);
                } else if (eventType == 16 && (module = OSGiRuntime.this.getModule(bundle)) != null) {
                    Map map = OSGiRuntime.this.uninstalled;
                    synchronized (map) {
                        OSGiRuntime.this.uninstalled.put(bundle.getBundleId(), module);
                        OSGiRuntime.this.uninstallModule(module);
                    }
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Module getModule(Bundle bundle) {
        Module module = super.getModule(bundle.getBundleId());
        if (module == null && bundle.getState() == 1) {
            Map<Long, Module> map = this.uninstalled;
            synchronized (map) {
                module = this.uninstalled.get(bundle.getBundleId());
                for (Long bundleId : new HashSet<Long>(this.uninstalled.keySet())) {
                    if (this.context.getBundle(bundleId.longValue()) != null) continue;
                    this.uninstalled.remove(bundleId);
                }
            }
        }
        return module;
    }

    public void init() {
        this.context.registerService(Runtime.class, (Object)this, null);
        this.streamHandlerTracker.open();
        this.context.addBundleListener(this.installListener);
        for (Bundle bundle : this.context.getBundles()) {
            this.installModule(bundle);
        }
    }

    BundleContext getSystemContext() {
        return this.context.getBundle(0L).getBundleContext();
    }

    protected AbstractModule createModule(ClassLoader classLoader, Resource resource, Dictionary<String, String> headers, Attachable context) {
        return new ModuleAdaptor(this, classLoader, resource, headers);
    }

    protected ModuleEntriesProvider getDefaultEntriesProvider(Module module, Attachable context) {
        return new OSGiModuleEntriesProvider(module);
    }

    protected void uninstallModule(Module module) {
        super.uninstallModule(module);
    }

    private Module installModule(Bundle bundle) {
        ClassLoader classLoader;
        Module module = this.getModule(bundle.getBundleId());
        if (module != null) {
            return module;
        }
        BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        ClassLoader classLoader2 = classLoader = wiring != null ? wiring.getClassLoader() : null;
        if (classLoader == null) {
            return null;
        }
        Resource resource = ThreadResourceAssociation.getResource();
        Dictionary headers = bundle.getHeaders();
        if (resource == null) {
            DictionaryResourceBuilder builder = new DictionaryResourceBuilder().load(headers);
            if (!builder.isValid()) {
                String symbolicName = bundle.getSymbolicName();
                String version = bundle.getVersion().toString();
                builder.addIdentityCapability(symbolicName, version);
            }
            resource = builder.getResource();
        }
        try {
            module = this.installModule(classLoader, resource, headers);
        }
        catch (ModuleException ex) {
            RuntimeLogger.LOGGER.error("Cannot install module from: " + bundle, (Throwable)ex);
        }
        return module;
    }

    public Runtime shutdown() {
        throw new UnsupportedOperationException();
    }

    private class OSGiModuleEntriesProvider
    implements ModuleEntriesProvider {
        private final Module module;

        OSGiModuleEntriesProvider(Module module) {
            this.module = module;
        }

        public List<String> getEntryPaths(String path) {
            Bundle bundle = OSGiRuntime.this.context.getBundle(this.module.getModuleId());
            Enumeration paths = bundle.getEntryPaths(path);
            ArrayList<String> result = new ArrayList<String>();
            if (paths != null) {
                while (paths.hasMoreElements()) {
                    String element = (String)paths.nextElement();
                    result.add(element);
                }
            }
            return Collections.unmodifiableList(result);
        }

        public URL getEntry(String path) {
            Bundle bundle = OSGiRuntime.this.context.getBundle(this.module.getModuleId());
            return bundle.getEntry(path);
        }

        public List<URL> findEntries(String path, String filePattern, boolean recurse) {
            Bundle bundle = OSGiRuntime.this.context.getBundle(this.module.getModuleId());
            Enumeration paths = bundle.findEntries(path, filePattern, recurse);
            ArrayList<URL> result = new ArrayList<URL>();
            if (paths != null) {
                while (paths.hasMoreElements()) {
                    URL element = (URL)paths.nextElement();
                    result.add(element);
                }
            }
            return Collections.unmodifiableList(result);
        }
    }
}

