/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.eventadmin.impl.handler;

import java.security.Permission;
import java.util.Collection;
import java.util.Iterator;
import org.apache.felix.eventadmin.impl.handler.EventHandlerTracker;
import org.apache.felix.eventadmin.impl.security.PermissionsUtil;
import org.apache.felix.eventadmin.impl.util.LogWrapper;
import org.osgi.framework.Bundle;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class EventHandlerProxy {
    private final ServiceReference reference;
    private final EventHandlerTracker.HandlerContext handlerContext;
    private volatile String[] topics;
    private volatile Filter filter;
    private volatile EventHandler handler;
    private volatile boolean blacklisted;
    private boolean useTimeout;
    private boolean asyncOrderedDelivery;

    public EventHandlerProxy(EventHandlerTracker.HandlerContext context, ServiceReference reference) {
        this.handlerContext = context;
        this.reference = reference;
    }

    public boolean update() {
        this.blacklisted = false;
        boolean valid = true;
        Object topicObj = this.reference.getProperty("event.topics");
        if (topicObj instanceof String) {
            this.topics = topicObj.toString().equals("*") ? null : new String[]{topicObj.toString()};
        } else if (topicObj instanceof String[]) {
            String[] values = (String[])topicObj;
            boolean matchAll = false;
            for (int i = 0; i < values.length; ++i) {
                if (!"*".equals(values[i])) continue;
                matchAll = true;
            }
            this.topics = matchAll ? null : values;
        } else if (topicObj instanceof Collection) {
            Collection col = (Collection)topicObj;
            String[] values = new String[col.size()];
            int index = 0;
            Iterator i = col.iterator();
            boolean matchAll = false;
            while (i.hasNext()) {
                String v;
                values[index] = v = i.next().toString();
                ++index;
                if (!"*".equals(v)) continue;
                matchAll = true;
            }
            this.topics = matchAll ? null : values;
        } else if (topicObj == null && !this.handlerContext.requireTopic) {
            this.topics = null;
        } else {
            String reason = topicObj == null ? "Missing" : "Neither of type String nor String[] : " + topicObj.getClass().getName();
            LogWrapper.getLogger().log(this.reference, 2, "Invalid EVENT_TOPICS : " + reason + " - Ignoring ServiceReference [" + this.reference + " | Bundle(" + this.reference.getBundle() + ")]");
            this.topics = null;
            valid = false;
        }
        Filter handlerFilter = null;
        if (valid) {
            Object filterObj = this.reference.getProperty("event.filter");
            if (filterObj instanceof String) {
                try {
                    handlerFilter = this.handlerContext.bundleContext.createFilter(filterObj.toString());
                }
                catch (InvalidSyntaxException e) {
                    valid = false;
                    LogWrapper.getLogger().log(this.reference, 2, "Invalid EVENT_FILTER - Ignoring ServiceReference [" + this.reference + " | Bundle(" + this.reference.getBundle() + ")]", e);
                }
            } else if (filterObj != null) {
                valid = false;
                LogWrapper.getLogger().log(this.reference, 2, "Invalid EVENT_FILTER - Ignoring ServiceReference [" + this.reference + " | Bundle(" + this.reference.getBundle() + ")]");
            }
        }
        this.filter = handlerFilter;
        this.asyncOrderedDelivery = true;
        String[] delivery = this.reference.getProperty("event.delivery");
        if (delivery instanceof Collection) {
            delivery = ((Collection)delivery).toArray(new String[((Collection)delivery).size()]);
        }
        if (delivery instanceof String) {
            this.asyncOrderedDelivery = !"async.unordered".equals(delivery.toString());
        } else if (delivery instanceof String[]) {
            String[] deliveryArray = delivery;
            boolean foundOrdered = false;
            boolean foundUnordered = false;
            for (int i = 0; i < deliveryArray.length; ++i) {
                String value = deliveryArray[i];
                if ("async.unordered".equals(value)) {
                    foundUnordered = true;
                    continue;
                }
                if ("async.ordered".equals(value)) {
                    foundOrdered = true;
                    continue;
                }
                LogWrapper.getLogger().log(this.reference, 2, "Invalid EVENT_DELIVERY - Ignoring invalid value for event delivery property " + value + " of ServiceReference [" + this.reference + " | Bundle(" + this.reference.getBundle() + ")]");
            }
            if (!foundOrdered && foundUnordered) {
                this.asyncOrderedDelivery = false;
            }
        } else if (delivery != null) {
            LogWrapper.getLogger().log(this.reference, 2, "Invalid EVENT_DELIVERY - Ignoring event delivery property " + delivery + " of ServiceReference [" + this.reference + " | Bundle(" + this.reference.getBundle() + ")]");
        }
        this.release();
        return valid;
    }

    public void dispose() {
        this.release();
    }

    private synchronized EventHandler obtain() {
        if (this.handler == null) {
            try {
                this.handler = (EventHandler)this.handlerContext.bundleContext.getService(this.reference);
                if (this.handler != null) {
                    this.checkTimeout(this.handler.getClass().getName());
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return this.handler;
    }

    private synchronized void release() {
        if (this.handler != null) {
            try {
                this.handlerContext.bundleContext.ungetService(this.reference);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.handler = null;
        }
    }

    public String[] getTopics() {
        return this.topics;
    }

    public boolean canDeliver(Event event) {
        if (this.blacklisted) {
            return false;
        }
        Bundle bundle = this.reference.getBundle();
        if (bundle == null) {
            return false;
        }
        Filter eventFilter = this.filter;
        if (eventFilter != null && !event.matches(eventFilter)) {
            return false;
        }
        Permission p = PermissionsUtil.createSubscribePermission(event.getTopic());
        return p == null || bundle.hasPermission((Object)p);
    }

    public boolean useTimeout() {
        return this.useTimeout;
    }

    public boolean isAsyncOrderedDelivery() {
        return this.asyncOrderedDelivery;
    }

    private void checkTimeout(String className) {
        if (this.handlerContext.ignoreTimeoutMatcher != null) {
            for (int i = 0; i < this.handlerContext.ignoreTimeoutMatcher.length; ++i) {
                if (this.handlerContext.ignoreTimeoutMatcher[i] == null || !this.handlerContext.ignoreTimeoutMatcher[i].match(className)) continue;
                this.useTimeout = false;
                return;
            }
        }
        this.useTimeout = true;
    }

    public void sendEvent(Event event) {
        EventHandler handlerService = this.obtain();
        if (handlerService == null) {
            return;
        }
        try {
            handlerService.handleEvent(event);
        }
        catch (Throwable e) {
            LogWrapper.getLogger().log(this.reference, 2, "Exception during event dispatch [" + event + " | " + this.reference + " | Bundle(" + this.reference.getBundle() + ")]", e);
        }
    }

    public void blackListHandler() {
        LogWrapper.getLogger().log(2, "Blacklisting ServiceReference [" + this.reference + " | Bundle(" + this.reference.getBundle() + ")] due to timeout!");
        this.blacklisted = true;
        this.release();
    }
}

