/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.metatype;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.felix.metatype.ADValidator;
import org.apache.felix.metatype.OptionalAttributes;
import org.apache.felix.metatype.internal.Activator;

public class AD
extends OptionalAttributes {
    public static final String VALIDATE_NOT_A_VALID_OPTION = "%not a valid option";
    public static final String VALIDATE_INVALID_VALUE = "%invalid value";
    public static final String VALIDATE_GREATER_THAN_MAXIMUM = "%greater than maximum";
    public static final String VALIDATE_LESS_THAN_MINIMUM = "%less than minimum";
    public static final String VALIDATE_MISSING = "%missing required value";
    private String id;
    private String name;
    private String description;
    private int type;
    private int cardinality = 0;
    private String[] optionLabels;
    private String[] optionValues;
    private String[] defaultValue;
    private String min;
    private String max;
    private boolean isRequired = true;

    public String getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public int getType() {
        return this.type;
    }

    public int getCardinality() {
        return this.cardinality;
    }

    public String[] getOptionLabels() {
        return this.optionLabels;
    }

    public String[] getOptionValues() {
        return this.optionValues;
    }

    public String[] getDefaultValue() {
        return this.defaultValue;
    }

    public String getMin() {
        return this.min;
    }

    public String getMax() {
        return this.max;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public String validate(String valueString) {
        return ADValidator.validate(this, valueString);
    }

    public void setID(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setType(String typeString) {
        this.type = AD.toType(typeString);
    }

    public void setCardinality(int cardinality) {
        this.cardinality = cardinality;
    }

    public void setOptions(Map options) {
        this.optionLabels = new String[options.size()];
        this.optionValues = new String[options.size()];
        int i = 0;
        Iterator oi = options.entrySet().iterator();
        while (oi.hasNext()) {
            Map.Entry entry = oi.next();
            this.optionValues[i] = String.valueOf(entry.getKey());
            this.optionLabels[i] = String.valueOf(entry.getValue());
            ++i;
        }
    }

    public void setDefaultValue(String defaultValue) {
        this.setDefaultValue(AD.splitList(defaultValue));
    }

    public void setMin(String min) {
        this.min = min;
    }

    public void setMax(String max) {
        this.max = max;
    }

    public void setDefaultValue(String[] values) {
        if (values != null) {
            int count = 0;
            for (int i = 0; i < values.length; ++i) {
                if ("".equals(ADValidator.validate(this, values[i]))) {
                    ++count;
                    continue;
                }
                values[i] = null;
            }
            if (count == 0) {
                values = null;
            } else if (count != values.length) {
                String[] filterValues = new String[count];
                int index = 0;
                for (int i = 0; i < values.length; ++i) {
                    if (values[i] == null) continue;
                    filterValues[index] = values[i];
                    ++index;
                }
                values = filterValues;
            }
        }
        this.defaultValue = values;
    }

    public void setRequired(boolean isRequired) {
        this.isRequired = isRequired;
    }

    public static int toType(String typeString) {
        if ("String".equals(typeString)) {
            return 1;
        }
        if ("Long".equals(typeString)) {
            return 2;
        }
        if ("Double".equals(typeString)) {
            return 7;
        }
        if ("Float".equals(typeString)) {
            return 8;
        }
        if ("Integer".equals(typeString)) {
            return 3;
        }
        if ("Byte".equals(typeString)) {
            return 6;
        }
        if ("Char".equals(typeString)) {
            return 5;
        }
        if ("Boolean".equals(typeString)) {
            return 11;
        }
        if ("Short".equals(typeString)) {
            return 4;
        }
        if ("Password".equals(typeString)) {
            return 12;
        }
        return 1;
    }

    public static String[] splitList(String listString) {
        if (listString == null) {
            return null;
        }
        if (listString.length() == 0) {
            return new String[]{""};
        }
        ArrayList<String> strings = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        int length = listString.length();
        boolean escaped = false;
        for (int i = 0; i < length; ++i) {
            char ch = listString.charAt(i);
            if (ch == '\\') {
                if (!escaped) {
                    escaped = true;
                    continue;
                }
            } else if (ch == ',') {
                if (!escaped) {
                    strings.add(sb.toString());
                    sb.setLength(0);
                    continue;
                }
            } else if (ch == ' ' ? !escaped : Character.isWhitespace(ch)) continue;
            sb.append(ch);
            escaped = false;
        }
        strings.add(sb.toString());
        return strings.toArray(new String[strings.size()]);
    }

    protected Comparable convertToType(String value) {
        if (value != null && value.length() > 0) {
            try {
                switch (this.getType()) {
                    case 11: {
                        return new ComparableBoolean(value);
                    }
                    case 5: {
                        return new Character(value.charAt(0));
                    }
                    case 6: {
                        return Byte.valueOf(value);
                    }
                    case 4: {
                        return Short.valueOf(value);
                    }
                    case 3: {
                        return Integer.valueOf(value);
                    }
                    case 2: {
                        return Long.valueOf(value);
                    }
                    case 8: {
                        return Float.valueOf(value);
                    }
                    case 7: {
                        return Double.valueOf(value);
                    }
                }
                return value;
            }
            catch (NumberFormatException nfe) {
                Activator.log(3, "Cannot convert value '" + value + "'", nfe);
            }
        }
        return null;
    }

    private static class ComparableBoolean
    implements Comparable {
        private boolean value;

        ComparableBoolean(String boolValue) {
            this.value = Boolean.valueOf(boolValue);
        }

        public int compareTo(Object obj) {
            ComparableBoolean cb = (ComparableBoolean)obj;
            return cb.value == this.value ? 0 : (this.value ? 1 : -1);
        }
    }
}

