/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.helper;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.felix.scr.impl.Activator;
import org.apache.felix.scr.impl.helper.BaseMethod;
import org.apache.felix.scr.impl.helper.ReadOnlyDictionary;
import org.apache.felix.scr.impl.helper.SimpleLogger;
import org.apache.felix.scr.impl.helper.SuitableMethodNotAccessibleException;
import org.apache.felix.scr.impl.manager.RefPair;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;

public class BindMethod
extends BaseMethod {
    private static final Class OBJECT_CLASS = Object.class;
    private final String m_referenceClassName;
    private static final int SERVICE_REFERENCE = 1;
    private static final int SERVICE_OBJECT = 2;
    private static final int SERVICE_OBJECT_AND_MAP = 3;
    private int m_paramStyle;

    public BindMethod(SimpleLogger logger, String methodName, Class componentClass, String referenceClassName, boolean isDS11, boolean isDS12Felix) {
        super(logger, methodName, componentClass, isDS11, isDS12Felix);
        this.m_referenceClassName = referenceClassName;
    }

    protected Method doFindMethod(Class targetClass, boolean acceptPrivate, boolean acceptPackage) throws SuitableMethodNotAccessibleException, InvocationTargetException {
        Method method;
        boolean suitableMethodNotAccessible = false;
        if (this.getLogger().isLogEnabled(4)) {
            this.getLogger().log(4, "doFindMethod: Looking for method " + targetClass.getName() + "." + this.getMethodName(), null);
        }
        try {
            method = this.getServiceReferenceMethod(targetClass, acceptPrivate, acceptPackage);
            if (method != null) {
                if (this.getLogger().isLogEnabled(4)) {
                    this.getLogger().log(4, "doFindMethod: Found Method " + method, null);
                }
                this.m_paramStyle = 1;
                return method;
            }
        }
        catch (SuitableMethodNotAccessibleException ex) {
            suitableMethodNotAccessible = true;
        }
        Class parameterClass = this.getParameterClass(targetClass);
        if (parameterClass != null) {
            if (this.getLogger().isLogEnabled(4)) {
                this.getLogger().log(4, "doFindMethod: No method taking ServiceReference found, checking method taking " + parameterClass.getName(), null);
            }
            try {
                method = this.getServiceObjectMethod(targetClass, parameterClass, acceptPrivate, acceptPackage);
                if (method != null) {
                    this.m_paramStyle = 2;
                    return method;
                }
            }
            catch (SuitableMethodNotAccessibleException ex) {
                suitableMethodNotAccessible = true;
            }
            try {
                method = this.getServiceObjectAssignableMethod(targetClass, parameterClass, acceptPrivate, acceptPackage);
                if (method != null) {
                    this.m_paramStyle = 2;
                    return method;
                }
            }
            catch (SuitableMethodNotAccessibleException ex) {
                suitableMethodNotAccessible = true;
            }
            if (this.isDS11()) {
                try {
                    method = this.getServiceObjectWithMapMethod(targetClass, parameterClass, acceptPrivate, acceptPackage);
                    if (method != null) {
                        this.m_paramStyle = 3;
                        return method;
                    }
                }
                catch (SuitableMethodNotAccessibleException ex) {
                    suitableMethodNotAccessible = true;
                }
                try {
                    method = this.getServiceObjectAssignableWithMapMethod(targetClass, parameterClass, acceptPrivate, acceptPackage);
                    if (method != null) {
                        this.m_paramStyle = 3;
                        return method;
                    }
                }
                catch (SuitableMethodNotAccessibleException ex) {
                    suitableMethodNotAccessible = true;
                }
            }
        } else if (this.getLogger().isLogEnabled(2)) {
            this.getLogger().log(2, "doFindMethod: Cannot check for methods taking parameter class " + this.m_referenceClassName + ": " + targetClass.getName() + " does not see it", null);
        }
        if (suitableMethodNotAccessible) {
            this.getLogger().log(1, "doFindMethod: Suitable but non-accessible method found in class {0}", new Object[]{targetClass.getName()}, null);
            throw new SuitableMethodNotAccessibleException();
        }
        return null;
    }

    private Class getParameterClass(Class targetClass) {
        if (this.getLogger().isLogEnabled(4)) {
            this.getLogger().log(4, "getParameterClass: Looking for interface class " + this.m_referenceClassName + "through loader of " + targetClass.getName(), null);
        }
        try {
            ClassLoader loader = targetClass.getClassLoader();
            if (loader == null) {
                loader = ClassLoader.getSystemClassLoader();
            }
            Class<?> referenceClass = loader.loadClass(this.m_referenceClassName);
            if (this.getLogger().isLogEnabled(4)) {
                this.getLogger().log(4, "getParameterClass: Found class " + referenceClass.getName(), null);
            }
            return referenceClass;
        }
        catch (ClassNotFoundException cnfe) {
            PackageAdmin pa;
            if (this.getLogger().isLogEnabled(4)) {
                this.getLogger().log(4, "getParameterClass: Not found through component class, using PackageAdmin service", null);
            }
            if ((pa = (PackageAdmin)Activator.getPackageAdmin()) != null) {
                String referenceClassPackage = this.m_referenceClassName.substring(0, this.m_referenceClassName.lastIndexOf(46));
                ExportedPackage[] pkg = pa.getExportedPackages(referenceClassPackage);
                if (pkg != null) {
                    for (int i = 0; i < pkg.length; ++i) {
                        try {
                            if (this.getLogger().isLogEnabled(4)) {
                                this.getLogger().log(4, "getParameterClass: Checking Bundle " + pkg[i].getExportingBundle().getSymbolicName() + "/" + pkg[i].getExportingBundle().getBundleId(), null);
                            }
                            Class referenceClass = pkg[i].getExportingBundle().loadClass(this.m_referenceClassName);
                            if (this.getLogger().isLogEnabled(4)) {
                                this.getLogger().log(4, "getParameterClass: Found class " + referenceClass.getName(), null);
                            }
                            return referenceClass;
                        }
                        catch (ClassNotFoundException cnfe2) {
                            continue;
                        }
                    }
                } else if (this.getLogger().isLogEnabled(4)) {
                    this.getLogger().log(4, "getParameterClass: No bundles exporting package " + referenceClassPackage + " found ", null);
                }
            } else if (this.getLogger().isLogEnabled(4)) {
                this.getLogger().log(4, "getParameterClass: PackageAdmin service not available, cannot find class", null);
            }
            if (this.getLogger().isLogEnabled(4)) {
                this.getLogger().log(4, "getParameterClass: No class found, falling back to class Object", null);
            }
            return OBJECT_CLASS;
        }
    }

    private Method getServiceReferenceMethod(Class targetClass, boolean acceptPrivate, boolean acceptPackage) throws SuitableMethodNotAccessibleException, InvocationTargetException {
        return this.getMethod(targetClass, this.getMethodName(), new Class[]{SERVICE_REFERENCE_CLASS}, acceptPrivate, acceptPackage);
    }

    private Method getServiceObjectMethod(Class targetClass, Class parameterClass, boolean acceptPrivate, boolean acceptPackage) throws SuitableMethodNotAccessibleException, InvocationTargetException {
        return this.getMethod(targetClass, this.getMethodName(), new Class[]{parameterClass}, acceptPrivate, acceptPackage);
    }

    private Method getServiceObjectAssignableMethod(Class targetClass, Class parameterClass, boolean acceptPrivate, boolean acceptPackage) throws SuitableMethodNotAccessibleException {
        Method[] candidateBindMethods = targetClass.getDeclaredMethods();
        boolean suitableNotAccessible = false;
        if (this.getLogger().isLogEnabled(4)) {
            this.getLogger().log(4, "getServiceObjectAssignableMethod: Checking " + candidateBindMethods.length + " declared method in class " + targetClass.getName(), null);
        }
        for (int i = 0; i < candidateBindMethods.length; ++i) {
            Class<?> theParameter;
            Class<?>[] parameters;
            Method method = candidateBindMethods[i];
            if (this.getLogger().isLogEnabled(4)) {
                this.getLogger().log(4, "getServiceObjectAssignableMethod: Checking " + method, null);
            }
            if ((parameters = method.getParameterTypes()).length != 1 || !method.getName().equals(this.getMethodName())) continue;
            if (this.getLogger().isLogEnabled(4)) {
                this.getLogger().log(4, "getServiceObjectAssignableMethod: Considering " + method, null);
            }
            if ((theParameter = parameters[0]).isAssignableFrom(parameterClass)) {
                if (BindMethod.accept(method, acceptPrivate, acceptPackage, false)) {
                    return method;
                }
                suitableNotAccessible = true;
                continue;
            }
            if (!this.getLogger().isLogEnabled(4)) continue;
            this.getLogger().log(4, "getServiceObjectAssignableMethod: Parameter failure: Required " + theParameter + "; actual " + parameterClass.getName(), null);
        }
        if (suitableNotAccessible) {
            throw new SuitableMethodNotAccessibleException();
        }
        return null;
    }

    private Method getServiceObjectWithMapMethod(Class targetClass, Class parameterClass, boolean acceptPrivate, boolean acceptPackage) throws SuitableMethodNotAccessibleException, InvocationTargetException {
        return this.getMethod(targetClass, this.getMethodName(), new Class[]{parameterClass, MAP_CLASS}, acceptPrivate, acceptPackage);
    }

    private Method getServiceObjectAssignableWithMapMethod(Class targetClass, Class parameterClass, boolean acceptPrivate, boolean acceptPackage) throws SuitableMethodNotAccessibleException {
        Method[] candidateBindMethods = targetClass.getDeclaredMethods();
        boolean suitableNotAccessible = false;
        for (int i = 0; i < candidateBindMethods.length; ++i) {
            Method method = candidateBindMethods[i];
            Class<?>[] parameters = method.getParameterTypes();
            if (parameters.length != 2 || !method.getName().equals(this.getMethodName()) || !parameters[0].isAssignableFrom(parameterClass) || parameters[1] != MAP_CLASS) continue;
            if (BindMethod.accept(method, acceptPrivate, acceptPackage, false)) {
                return method;
            }
            suitableNotAccessible = true;
        }
        if (suitableNotAccessible) {
            throw new SuitableMethodNotAccessibleException();
        }
        return null;
    }

    public boolean getServiceObject(RefPair refPair, BundleContext context) {
        if (refPair.getServiceObject() == null && this.methodExists() && (this.m_paramStyle == 2 || this.m_paramStyle == 3)) {
            Object service = context.getService(refPair.getRef());
            if (service == null) {
                this.getLogger().log(2, "Could not get service from ref " + refPair.getRef(), null);
                return false;
            }
            refPair.setServiceObject(service);
            return true;
        }
        return true;
    }

    protected Object[] getParameters(Method method, Object rawParameter) {
        RefPair refPair = (RefPair)rawParameter;
        if (this.m_paramStyle == 1) {
            return new Object[]{refPair.getRef()};
        }
        if (this.m_paramStyle == 2) {
            return new Object[]{refPair.getServiceObject()};
        }
        if (this.m_paramStyle == 3) {
            return new Object[]{refPair.getServiceObject(), new ReadOnlyDictionary(refPair.getRef())};
        }
        throw new IllegalStateException("Unexpected m_paramStyle of " + this.m_paramStyle);
    }

    protected String getMethodNamePrefix() {
        return "bind";
    }

    public static interface Service {
        public ServiceReference getReference();

        public Object getInstance();
    }
}

