/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.jboss.gravia.utils.IOUtils;

public final class ManifestUtils {
    private ManifestUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Manifest getManifest(InputStream input) {
        JarInputStream jarStream;
        if (input instanceof JarInputStream) {
            jarStream = (JarInputStream)input;
        } else {
            try {
                jarStream = new JarInputStream(input);
            }
            catch (IOException ex) {
                return null;
            }
        }
        try {
            Manifest manifest = jarStream.getManifest();
            if (manifest == null) {
                try {
                    JarEntry entry = jarStream.getNextJarEntry();
                    while (entry != null) {
                        if (entry.getName().equals("META-INF/MANIFEST.MF")) {
                            manifest = new Manifest(jarStream);
                            break;
                        }
                        entry = jarStream.getNextJarEntry();
                    }
                }
                catch (IOException ex) {
                    Manifest manifest2 = null;
                    IOUtils.safeClose(jarStream);
                    return manifest2;
                }
            }
            Manifest manifest3 = manifest;
            return manifest3;
        }
        finally {
            IOUtils.safeClose(jarStream);
        }
    }

    public static Dictionary<String, String> getManifestHeaders(Manifest manifest) {
        Hashtable<String, String> headers = new Hashtable<String, String>();
        Attributes mainatts = manifest.getMainAttributes();
        for (Object key : mainatts.keySet()) {
            String name = key.toString();
            String value = mainatts.getValue(name);
            headers.put(name, value);
        }
        return headers;
    }
}

