/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.transport;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.cometd.bayeux.server.BayeuxContext;
import org.cometd.server.AbstractServerTransport;
import org.cometd.server.BayeuxServerImpl;

public abstract class HttpTransport
extends AbstractServerTransport {
    public static final String JSON_DEBUG_OPTION = "jsonDebug";
    public static final String MESSAGE_PARAM = "message";
    private final ThreadLocal<HttpServletRequest> _currentRequest = new ThreadLocal();

    protected HttpTransport(BayeuxServerImpl bayeux, String name) {
        super(bayeux, name);
    }

    public abstract boolean accept(HttpServletRequest var1);

    public abstract void handle(HttpServletRequest var1, HttpServletResponse var2) throws IOException, ServletException;

    public void setCurrentRequest(HttpServletRequest request) {
        this._currentRequest.set(request);
    }

    public HttpServletRequest getCurrentRequest() {
        return this._currentRequest.get();
    }

    public InetSocketAddress getCurrentLocalAddress() {
        BayeuxContext context = this.getContext();
        if (context != null) {
            return context.getLocalAddress();
        }
        return null;
    }

    public InetSocketAddress getCurrentRemoteAddress() {
        BayeuxContext context = this.getContext();
        if (context != null) {
            return context.getRemoteAddress();
        }
        return null;
    }

    public BayeuxContext getContext() {
        HttpServletRequest request = this.getCurrentRequest();
        if (request != null) {
            return new HttpContext(request);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HttpContext
    implements BayeuxContext {
        final HttpServletRequest _request;

        HttpContext(HttpServletRequest request) {
            this._request = request;
        }

        @Override
        public Principal getUserPrincipal() {
            return this._request.getUserPrincipal();
        }

        @Override
        public boolean isUserInRole(String role) {
            return this._request.isUserInRole(role);
        }

        @Override
        public InetSocketAddress getRemoteAddress() {
            return new InetSocketAddress(this._request.getRemoteHost(), this._request.getRemotePort());
        }

        @Override
        public InetSocketAddress getLocalAddress() {
            return new InetSocketAddress(this._request.getLocalName(), this._request.getLocalPort());
        }

        @Override
        public String getHeader(String name) {
            return this._request.getHeader(name);
        }

        @Override
        public List<String> getHeaderValues(String name) {
            return Collections.list(this._request.getHeaders(name));
        }

        @Override
        public String getParameter(String name) {
            return this._request.getParameter(name);
        }

        @Override
        public List<String> getParameterValues(String name) {
            return Arrays.asList(this._request.getParameterValues(name));
        }

        @Override
        public String getCookie(String name) {
            Cookie[] cookies = this._request.getCookies();
            if (cookies != null) {
                for (Cookie c : cookies) {
                    if (!name.equals(c.getName())) continue;
                    return c.getValue();
                }
            }
            return null;
        }

        @Override
        public String getHttpSessionId() {
            HttpSession session = this._request.getSession(false);
            if (session != null) {
                return session.getId();
            }
            return null;
        }

        @Override
        public Object getHttpSessionAttribute(String name) {
            HttpSession session = this._request.getSession(false);
            if (session != null) {
                return session.getAttribute(name);
            }
            return null;
        }

        @Override
        public void setHttpSessionAttribute(String name, Object value) {
            HttpSession session = this._request.getSession(false);
            if (session == null) {
                throw new IllegalStateException("!session");
            }
            session.setAttribute(name, value);
        }

        @Override
        public void invalidateHttpSession() {
            HttpSession session = this._request.getSession(false);
            if (session != null) {
                session.invalidate();
            }
        }

        @Override
        public Object getRequestAttribute(String name) {
            return this._request.getAttribute(name);
        }

        private ServletContext getServletContext() {
            HttpSession s = this._request.getSession(false);
            if (s != null) {
                return s.getServletContext();
            }
            s = this._request.getSession(true);
            ServletContext servletContext = s.getServletContext();
            s.invalidate();
            return servletContext;
        }

        @Override
        public Object getContextAttribute(String name) {
            return this.getServletContext().getAttribute(name);
        }

        @Override
        public String getContextInitParameter(String name) {
            return this.getServletContext().getInitParameter(name);
        }

        @Override
        public String getURL() {
            StringBuffer url = this._request.getRequestURL();
            String query = this._request.getQueryString();
            if (query != null) {
                url.append("?").append(query);
            }
            return url.toString();
        }
    }
}

