/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.config;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.felix.scr.impl.Activator;
import org.apache.felix.scr.impl.BundleComponentActivator;
import org.apache.felix.scr.impl.ComponentRegistry;
import org.apache.felix.scr.impl.config.ComponentHolder;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationSupport
implements ConfigurationListener {
    private final ComponentRegistry m_registry;
    private ServiceRegistration m_registration;

    public ConfigurationSupport(BundleContext bundleContext, ComponentRegistry registry) {
        this.m_registry = registry;
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.description", "Declarative Services Configuration Support Listener");
        ((Dictionary)props).put("service.vendor", "The Apache Software Foundation");
        this.m_registration = bundleContext.registerService(new String[]{"org.osgi.service.cm.ConfigurationListener"}, (Object)this, props);
    }

    public void dispose() {
        if (this.m_registration != null) {
            this.m_registration.unregister();
            this.m_registration = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configureComponentHolder(ComponentHolder holder) {
        if (!holder.getComponentMetadata().isConfigurationIgnored()) {
            Object cao;
            BundleContext bundleContext = holder.getActivator().getBundleContext();
            String bundleLocation = bundleContext.getBundle().getLocation();
            String confPid = holder.getComponentMetadata().getConfigurationPid();
            ServiceReference caRef = bundleContext.getServiceReference("org.osgi.service.cm.ConfigurationAdmin");
            if (caRef != null && (cao = bundleContext.getService(caRef)) != null) {
                try {
                    if (cao instanceof ConfigurationAdmin) {
                        ConfigurationAdmin ca = (ConfigurationAdmin)cao;
                        Configuration[] factory = this.findFactoryConfigurations(ca, confPid);
                        if (factory != null) {
                            for (int i = 0; i < factory.length; ++i) {
                                String pid = factory[i].getPid();
                                Dictionary props = this.getConfiguration(ca, pid, bundleLocation);
                                holder.configurationUpdated(pid, props);
                            }
                        } else {
                            Configuration singleton = this.findSingletonConfiguration(ca, confPid);
                            if (singleton != null) {
                                Dictionary props = this.getConfiguration(ca, confPid, bundleLocation);
                                holder.configurationUpdated(confPid, props);
                            }
                        }
                    } else {
                        Activator.log(2, null, "Cannot configure component " + holder.getComponentMetadata().getName(), null);
                        Activator.log(2, null, "Component Bundle's Configuration Admin is not compatible with ours. This happens if multiple Configuration Admin API versions are deployed and different bundles wire to different versions", null);
                        Class<?> caoc = cao.getClass();
                    }
                }
                finally {
                    try {
                        bundleContext.ungetService(caRef);
                    }
                    catch (IllegalStateException e) {}
                }
            }
        }
    }

    public void configureComponentHolders(ServiceReference<ConfigurationAdmin> configurationAdminReference, Object configurationAdmin) {
        Configuration[] configs;
        if (configurationAdmin instanceof ConfigurationAdmin && (configs = this.findConfigurations((ConfigurationAdmin)configurationAdmin, null)) != null) {
            for (int i = 0; i < configs.length; ++i) {
                ConfigurationEvent cfgEvent = new ConfigurationEvent(configurationAdminReference, 1, configs[i].getFactoryPid(), configs[i].getPid());
                this.configurationEvent(cfgEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configurationEvent(ConfigurationEvent event) {
        String pid = event.getPid();
        String factoryPid = event.getFactoryPid();
        Iterator it = factoryPid == null ? this.m_registry.getComponentHoldersByPid(pid) : this.m_registry.getComponentHoldersByPid(factoryPid);
        Activator.log(4, null, "configurationEvent: Handling " + (event.getType() == 2 ? "DELETE" : "UPDATE") + " of Configuration PID=" + pid, null);
        block10: while (it.hasNext()) {
            ComponentHolder cm = (ComponentHolder)it.next();
            if (cm.getComponentMetadata().isConfigurationIgnored()) continue;
            switch (event.getType()) {
                case 2: {
                    cm.configurationDeleted(pid);
                    break;
                }
                case 1: {
                    BundleContext bundleContext;
                    BundleComponentActivator activator = cm.getActivator();
                    if (activator == null || (bundleContext = activator.getBundleContext()) == null) break;
                    ServiceReference caRef = bundleContext.getServiceReference("org.osgi.service.cm.ConfigurationAdmin");
                    if (caRef == null) continue block10;
                    try {
                        Object cao = bundleContext.getService(caRef);
                        if (cao == null) continue block10;
                        try {
                            if (cao instanceof ConfigurationAdmin) {
                                ConfigurationAdmin ca = (ConfigurationAdmin)cao;
                                Dictionary dict = this.getConfiguration(ca, pid, bundleContext.getBundle().getLocation());
                                if (dict == null) continue block10;
                                cm.configurationUpdated(pid, dict);
                                continue block10;
                            }
                            Activator.log(2, null, "Cannot reconfigure component " + cm.getComponentMetadata().getName(), null);
                            Activator.log(2, null, "Component Bundle's Configuration Admin is not compatible with ours. This happens if multiple Configuration Admin API versions are deployed and different bundles wire to different versions", null);
                            continue block10;
                        }
                        finally {
                            bundleContext.ungetService(caRef);
                            continue block10;
                        }
                    }
                    catch (IllegalStateException ise) {
                        Activator.log(2, null, "Unknown ConfigurationEvent type " + event.getType(), ise);
                        break;
                    }
                }
                case 3: {
                    break;
                }
                default: {
                    Activator.log(2, null, "Unknown ConfigurationEvent type " + event.getType(), null);
                }
            }
        }
    }

    private Dictionary getConfiguration(ConfigurationAdmin ca, String pid, String bundleLocation) {
        try {
            Configuration cfg = ca.getConfiguration(pid);
            if (bundleLocation.equals(cfg.getBundleLocation())) {
                return cfg.getProperties();
            }
            Activator.log(1, null, "Cannot use configuration pid=" + pid + " for bundle " + bundleLocation + " because it belongs to bundle " + cfg.getBundleLocation(), null);
        }
        catch (IOException ioe) {
            Activator.log(2, null, "Failed reading configuration for pid=" + pid, ioe);
        }
        return null;
    }

    public Configuration findSingletonConfiguration(ConfigurationAdmin ca, String pid) {
        String filter = "(service.pid=" + pid + ")";
        Configuration[] cfg = this.findConfigurations(ca, filter);
        return cfg == null || cfg.length == 0 ? null : cfg[0];
    }

    public Configuration[] findFactoryConfigurations(ConfigurationAdmin ca, String factoryPid) {
        String filter = "(service.factoryPid=" + factoryPid + ")";
        return this.findConfigurations(ca, filter);
    }

    private Configuration[] findConfigurations(ConfigurationAdmin ca, String filter) {
        try {
            return ca.listConfigurations(filter);
        }
        catch (IOException ioe) {
            Activator.log(2, null, "Problem listing configurations for filter=" + filter, ioe);
        }
        catch (InvalidSyntaxException ise) {
            Activator.log(1, null, "Invalid Configuration selection filter " + filter, ise);
        }
        return null;
    }
}

